<?

/**************************************************************************
 * Add a user to the SNUI user and authentication database.
 *
 * Copyright (C) 2002, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id$
 
require_once("/etc/snui/snui_admin.conf");

require_once("phtml/html.inc");
require_once("phtml/form.inc");
require_once("phtml/table.inc");
require_once("phtml/misc.inc");
require_once("phtml/log.inc");

require_once("passwd.inc");

log_open("MAINLOG", "$SNUI_LOG_DIR/snui_admin.log", "adduser");
log_open("NEWUSERLOG", "$SNUI_LOG_DIR/snui_newuser.log", "adduser");

echo html_header("Add New User");

$reqd = array("auth_username", "auth_password", "username", "password"
		,"password_confirm", "realname");
		
if (!all_reqd($reqd)) {
	echo html_h1("Add new user");
	
	echo "<p>You need administrative access to add a new user.  If you are
	not authorised to perform this operation, please give up now.";
	
	echo "<p>Enter your own username and password below.";
	
	echo form_header("adduser.php");
	echo table_header();
	echo table_row("<b>Username: </b>", form_textbox("auth_username", NULL, 15));
	echo table_row("<b>Password: </b>", form_password("auth_password", NULL));
	echo table_footer();
	
	echo "<p>Now in the spaces below, please enter the details of the
	new user you wish to create."; 

	echo table_header();
	echo table_row("<b>Username: </b>", form_textbox("username", NULL, 15));
	echo table_row("<b>Real Name: </b>", form_textbox("realname", NULL, 40, 20));
	echo table_row("<b>Password: </b>", form_password("password", NULL));
	echo table_row("<b>Password Confirm: </b>", form_password("password_confirm", NULL));
	echo table_footer();
	
	echo "<p>Click the button below to create the user, or use the
	'Back' button on your browser to return from whence you came."; 

	echo "<p>";
	echo form_submit("Create User");
	
	echo form_footer();
	
	echo html_footer();

	return;
}

if ($HTTP_POST_VARS["password"] != $HTTP_POST_VARS["password_confirm"]) {
	echo html_h1("User NOT created");
	echo "<p>The passwords the user entered were not the same.  Use the
		button below to try again.\n";
		
	echo button_try_again("adduser.php");

	echo html_footer();

	return;
}
	
if (!admin_auth_check($HTTP_POST_VARS["auth_username"], $HTTP_POST_VARS["auth_password"])) {
	echo "<p>You failed to successfully authenticate yourself.  Please
		use the button below to go back and try again.\n";
	
	echo button_try_again("adduser.php");
	
	echo html_footer();
	
	return;
}

$new_record["username"] = $HTTP_POST_VARS["username"];
$new_record["password"] = "x";
$new_record["gecos"] = $HTTP_POST_VARS["realname"];
$new_record["gid"] = $SNUI_ADDUSER_GROUP;
$new_record["uid"] = first_available_uid($SNUI_USERDB);
$new_record["homedir"] = $SNUI_ADDUSER_HOMEDIR_PREFIX."/".$new_record["username"];
$new_record["shell"] = $SNUI_ADDUSER_SHELL;

$auth_record["username"] = $new_record["username"];
$auth_record["password"] = md5($HTTP_POST_VARS["password"]);

$userdata = read_passwd($SNUI_USERDB);
if (is_string($userdata)) {
	echo "<p>A serious error occured while processing your request.
		Please inform the administrator.\n";
	
	logmsg("MAINLOG", "Failed to open user DB $SNUI_USERDB: $user_list");
	
	echo html_footer();
	
	return;
}

for ($i = 0; $i < count($userdata); $i++) {
	if ($userdata[$i]["username"] == $HTTP_POST_VARS["username"]) {
		echo "<p>The username you entered already exists.  Please use
			the button below to go back and enter a different
			username.\n";
		
		echo button_try_again("adduser.php");
		
		echo html_footer();
		
		return;
	}
}

$userdata[] = $new_record;

$rv = write_passwd($SNUI_USERDB, $userdata);
if (is_string($rv)) {
	echo "<p>A serious error occured while processing your request.
		Please inform the administrator.\n";
	
	logmsg("MAINLOG", "Failed to update user DB $SNUI_USERDB: $rv");
	
	echo html_footer();
	
	return;
}

$authdata = read_auth($SNUI_AUTHDB);
if (is_string($authdata)) {
	echo "<p>A serious error occured while processing your request.
		Please inform the administrator.\n";
	
	logmsg("MAINLOG", "Failed to open auth DB $SNUI_AUTHDB: $authdata");
	
	echo html_footer();
	
	return;
}

$authdata[] = $auth_record;

$rv = write_auth($SNUI_AUTHDB, $authdata);
if (is_string($rv)) {
	echo "<p>A serious error occured while processing your request.
		Please inform the administrator.\n";
	
	logmsg("MAINLOG", "Failed to update auth DB $SNUI_AUTHDB: $rv");
	
	echo html_footer();
	
	return;
}

// Now add the new user to all the appropriate groups
if ($SNUI_ADDUSER_EXTRAGROUPS != "") {
	$new_groups = split(',', $SNUI_ADDUSER_EXTRAGROUPS);
	foreach ($new_groups as $g) {
		$rv = add_user_to_group($new_record["username"], $g, $SNUI_GROUPDB);
		if (is_string($rv)) {
			echo "<p>A serious error occured while processing
				your request.  Please inform the administrator.\n";
			
			logmsg("MAINLOG", "Failed to add user to group DB $SNUI_GROUPDB: $rv");
		
			echo html_footer();
		
			return;
		}
	}
}

// Hey, we managed to get everything done!
echo html_h1("User created");

echo "<p>The new user has been created.  They may now partake of the full
	variety of services on offer.\n";

echo html_footer();

