%{
/**************************************************************************
 * Lexer for the confhandler.
 *
 * Copyright (C) 2000, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

static char rcsid[] = "$Id";

#include "fileconf.h"
#include "fileconf.tab.h"

#define YY_DECL	int conf_lex(YYSTYPE *value)
%}

%option noyywrap

%s DATA

%%

([[:space:]]|\n)*	/* Ignore */

#.*$			/* Mmm, tasty comments - burp! */

\[			{ return TOK_OB; }

\]			{ return TOK_CB; }

=			{ BEGIN(DATA); return TOK_EQUAL; }

[A-Za-z0-9\-_]*/[ \t]*=	{
				value->str = malloc(strlen(yytext) + 1);
				if (!value->str) {
					fprintf(stderr, "Error allocating memory");
					/* XXX What to do here? */
				} else {
					strcpy(value->str, yytext);
				}
				return VAL_TAG;
			}

<DATA>.*$		{
				value->str = malloc(strlen(yytext) + 1);
				if (!value->str) {
					fprintf(stderr, "Error allocating memory");
					/* XXX do here? */
				} else {
					strcpy(value->str, yytext);
				}
				BEGIN(0);
				return VAL_DATA;
			}

[A-Za-z0-9\-_ \t]*		{
				value->str = malloc(strlen(yytext) + 1);
				if (!value->str) {
					fprintf(stderr, "Error allocating memory");
					/* XXX do here? */
				} else {
					strcpy(value->str, yytext);
				}
				return VAL_SECTION;
			}
				
.			/* Chew up any characters not otherwise matched - burp! */
%%
