/*
 * This is the header file for the MD5 message-digest algorithm.
 * The algorithm is due to Ron Rivest.  This code was
 * written by Colin Plumb in 1993, no copyright is claimed.
 * This code is in the public domain; do with it what you wish.
 *
 * Equivalent code is available from RSA Data Security, Inc.
 * This code has been tested against that, and is equivalent,
 * except that you don't need to include two pages of legalese
 * with every copy.
 *
 * To compute the message digest of a chunk of bytes, declare an
 * MD5Context structure, pass it to MD5Init, call MD5Update as
 * needed on buffers full of bytes, and then call MD5Final, which
 * will fill a supplied 16-byte array with the digest.
 *
 * Changed so as no longer to depend on Colin Plumb's `usual.h'
 * header definitions; now uses stuff from dpkg's config.h
 *  - Ian Jackson <ijackson@nyx.cs.du.edu>.
 * Still in the public domain.
 *
 * Changed so it doesn't need anything else - completely self-contained.
 *  - Matthew Palmer <mpalmer@debian.org>
 * Still in the public domain.
 */

#ifndef MD5_H
#define MD5_H

#define md5byte unsigned char

/* This needs to be fixed before too long. */
#define UWORD32 unsigned int

struct MD5Context {
	UWORD32 buf[4];
	UWORD32 bytes[2];
	UWORD32 in[16];
};

void MD5Init(struct MD5Context *context);
void MD5Update(struct MD5Context *context, md5byte const *buf, unsigned len);
void MD5Final(unsigned char digest[16], struct MD5Context *context);
void MD5Transform(UWORD32 buf[4], UWORD32 const in[16]);

#endif /* !MD5_H */
/**************************************************************************
 * Network functions for SNUI.
 *
 * Copyright (C) 2002, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

#ifndef SNUI_NET_H
#define SNUI_NET_H

/* Initialise network connection to server.
 */
int net_client_init(char *config_section, FILE **socket);

/* Initialise a network server port.  Places the socket, suitable for
 * accept()ing on, in srvsock.
 */
int net_server_init(int port, int *srvsock);

/* Read a response line (of the form "NNN Textual Response")
 */
int net_read_response(FILE *fd, int *NNN, char *text, int textlen);

/* Listen on the port and the sock for a new connection coming in.  Hands
 * back the socket to talk to the client through newsock, and returns 0
 * on success and errno on error.
 */
int net_get_connection(int sock, int port, int *newsock);

#endif  /* SNUI_NET_H */
/**************************************************************************
 * Configuration file handling functions.
 *
 * Copyright (C) 2000, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

#ifndef MARKET_FILECONF_H
#define MARKET_FILECONF_H

/************\
* Data types *
\************/
struct conf_item {
	char *tag;
	char *data;
};

typedef struct conf_item_ll_s {
	struct conf_item *item;
	struct conf_item_ll_s *nextitem;
} conf_item_ll_t;

typedef struct conf_section_ll_s {
	char *sectname;
	conf_item_ll_t *headitem;
	conf_item_ll_t *curitem;
	struct conf_section_ll_s *nextsect;
} conf_section_ll_t;

typedef struct {
	conf_section_ll_t *headsect;
	conf_section_ll_t *cursect;
} conf_file_t;

/***********\
* Functions *
\***********/

/* Read filename for config options.  Returns NULL on error (with errno) or
 * a pointer to the config info on success.
 */
conf_file_t *conf_read_file(char *filename);

/* Delete all the data associated with the config info given.
 */
void conf_free_file(conf_file_t *conf);

/* Returns the name of the next section in the config file (which we are now
 * referring to for all our config needs) or NULL if there are no more config
 * sections.
 */
char *conf_next_section(conf_file_t *conffile);

/* Find a config section called sectname, and change the config record to
 * use that section.  Returns 1 if we found it, or 0 if not.
 */
int conf_find_section(conf_file_t *conffile, char *sectname);

/* Move to the nth section in the config file.  Returns 1 if success, or 0
 * if there aren't that many sections in the config file.
 */
int conf_seek_section(conf_file_t *conffile, int n);

/* Returns a pointer to a struct containing the tag and value of the next
 * config item in the currect section, or NULL if there are no more items in
 * the current section.
 */
struct conf_item *conf_next_item(conf_file_t *conffile);

/* Returns the value of the given tag in the current section, or NULL if no
 * such tag exists in this section.
 */
char *conf_find_item(conf_file_t *conffile, char *tag);

/* Moves the internal pointer to the nth config item in the current section.
 * Returns 1 on success or 0 if there are less than n items in the section.
 */
int conf_seek_item(conf_file_t *conffile, int n);


#endif  /* MARKET_FILECONF_H */
