/**************************************************************************
 * Network functions for SNUI.
 *
 * Copyright (C) 2002, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

#ifndef SNUI_NET_H
#define SNUI_NET_H

/* Initialise network connection to server.
 */
int net_client_init(char *config_section, FILE **socket);

/* Initialise a network server port.  Places the socket, suitable for
 * accept()ing on, in srvsock.
 */
int net_server_init(int port, int *srvsock);

/* Read a response line (of the form "NNN Textual Response")
 */
int net_read_response(FILE *fd, int *NNN, char *text, int textlen);

/* Listen on the port and the sock for a new connection coming in.  Hands
 * back the socket to talk to the client through newsock, and returns 0
 * on success and errno on error.
 */
int net_get_connection(int sock, int port, int *newsock);

#endif  /* SNUI_NET_H */
