/*
 * ---------------------------------------------------------------------
 * diskimage.h
 *	Interface to diskimage library	
 *
 * (C) 2005 Jochen Karrer
 *    Author: Jochen Karrer
 *
 * Status: Working
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------
 */

#ifndef DISKIMAGE_H
#define DISKIMAGE_H

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/mman.h>
#include <sys/types.h>

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdint.h>

#define DI_RDWR		(16)
#define DI_CREAT_FF	(1)
#define	DI_CREAT_00	(2)
#define DI_SPARSE	(4)
typedef struct DiskImage {
	int fd;
	uint64_t size;
	void *map;
} DiskImage;

void DiskImage_Close(DiskImage *di);
DiskImage * DiskImage_Open(const char *name,uint64_t size,int flags);

void * DiskImage_Mmap(DiskImage *di); 

int DiskImage_Read(DiskImage *di,off64_t ofs,uint8_t *buf,int count);
int DiskImage_Write(DiskImage *di,off64_t ofs,const uint8_t *buf,int count);

#endif
