/*
 * ----------------------------------------------------------------------
 *
 * Main for standalone PCL3GUI to image converter
 *
 * (C) 2006 Jochen Karrer
 *   Author: Jochen Karrer
 *
 * state: working
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "dj460interp.h"
int
main(int argc,char *argv[]) 
{
	Dj460Interp *interp;
	int fd;
	int count;
	uint8_t buf[4096];
	int result,result2;
	if(argc < 3) {
		fprintf(stderr,"Syntax:\n\t%s pclfile.pcl <outputdir>\n\n",argv[0]);
		exit(1);
	}
	fd = open(argv[1],O_RDONLY);
	if(fd<0) {
		perror("can not open pcl file");
		exit(1);
	}	
	
	interp =  Dj460Interp_New(argv[2]);
	do {
		result = read(fd,buf,sizeof(buf));
		if(result < 0) {
			perror("error reading pcl file");
			exit(1);
		} else if (result == 0) {
			Dj460Interp_Reset(interp);
			exit(0);
		}
		for(count = 0;count<result;) {
			result2 = Dj460Interp_Feed(interp,buf,result);
			if(result2<=0) {
				fprintf(stderr,"Can not feed the interpreter\n");
				break;
			}	
			count+=result2;
		}
	} while(1);
	exit(0);	
}
