/*
 * ----------------------------------------------------------------------
 *
 * Deskjet 460 Emulator Interpreter main loop
 *
 * (C) 2006 Jochen Karrer
 *   Author: Jochen Karrer
 *
 * state: working 
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "printer.h"
#include "printengine.h"
#include "dj460interp.h"
#include "pjl.h"
#include "pcl3.h"
#include "pcl3gui.h"
#include "sgstring.h"

struct Dj460Interp {
	int curlang;
	PrintEngine *print_engine;
	PJL_Interp *pjl_interp;
	PCL3_Interp *pcl3_interp;
	PCL3GUI_Interp *pcl3gui_interp;
};

Dj460Interp *
Dj460Interp_New(const char *outfiledir)
{
	Dj460Interp *interp = sg_new(Dj460Interp);
	PrintEngine *pe;
	pe = interp->print_engine = PEng_New(outfiledir); 
	interp->pjl_interp = PJLInterp_New();
	interp->pcl3_interp = PCL3Interp_New();
	interp->pcl3gui_interp = PCL3GUIInterp_New(pe);
	interp->curlang = Pl_Pcl3;
	fprintf(stderr,"DJ460 PCL3/PCL3GUI interpreter created\n");
	return interp;
}

void
Dj460Interp_Reset(Dj460Interp *interp) 
{
	PJLInterp_Reset(interp->pjl_interp);
	PCL3Interp_Reset(interp->pcl3_interp);
	PCL3GUIInterp_Reset(interp->pcl3gui_interp);
}
/*
 * -----------------------------------------------------------------------
 * Feed the interpreter with print data
 * -----------------------------------------------------------------------
 */
int
Dj460Interp_Feed(Dj460Interp *interp,void *buf,int len)
{
	int result;
	int count = 0; 
	int done = 0;
	while(count < len) {
		switch(interp->curlang) {
			case 0:
				fprintf(stderr,"Done\n");
				exit(0);

			case Pl_Pjl:
				result = PJLInterp_Feed(interp->pjl_interp,buf+count,len-count,&interp->curlang);
				break;

			case Pl_Pcl3:
				result = PCL3Interp_Feed(interp->pcl3_interp,buf+count,len-count,&done);
				if(done) {
					interp->curlang = Pl_Pjl;
				}
				break;

			case Pl_Pcl3Gui:
				result =  PCL3GUIInterp_Feed(interp->pcl3gui_interp,buf+count,len-count,&done);
				if(done) {
					fprintf(stderr,"PCL3GUI is done\n");
					interp->curlang = Pl_Pjl;
				}
				break;
			default:
				result = -1;
				fprintf(stderr,"Unknown Printer language %d\n",interp->curlang);
				break;
		}
		if(result <= 0) {
			return result;
		}
		count+=result;
		//fprintf(stderr,"New lang %d\n",interp->curlang);
	}
	return count;
}

