/*
 ***************************************************************************
 * sglib.c
 *    Some usefull functions needed everythere 
 *
 * (C) 2009 Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 ***************************************************************************
 */

#include "sgtypes.h"

/*
 ***************************************+
 * find ggt euklid used to reduce
 * clock multiplier/divider pairs
 ***************************************+
 */
static uint64_t
find_ggt_mod(uint64_t u, uint64_t v){
        uint64_t tmp;
        while( u > 0) {
            tmp = u;
            u = v % u;
            v = tmp;
        }
        return v;
}


/*
 ********************************************
 * reduce a fraction
 ********************************************
 */
void
FractionU64_Reduce(FractionU64_t *frac)
{
        uint64_t ggt = find_ggt_mod(frac->nom,frac->denom);
        if(ggt > 1) {
                frac->nom /= ggt;
                frac->denom /= ggt;
        }
}



static unsigned int
onecount_slow(const uint32_t value)
{
        uint32_t val=value;
        int ones=0;
        while(val) {
                if(val&1)
                        ones++;
                val>>=1;
        }
        return ones;
}

/*
 ******************************************************
 * Count ones in a word
 ******************************************************
 */
uint8_t sglib_onecount_map[256];

static void
init_onecount_map(void)
{
        int j;
        for(j=0; j<256; ++j) {
                 sglib_onecount_map[j] = onecount_slow(j);
        }
}

/**
 ***********************************************************++
 * Decode a 32 Bit number from Gray code
 ***********************************************************++
 */

uint32_t
GrayDecodeU32(uint32_t to_decode) {
        uint32_t result = to_decode ^ (to_decode >> 16);
        result ^= result >> 8;
        result ^= result >> 4;
        result ^= result >> 2;
        result ^= result >> 1;
        return result;
}

void
SGLib_Init(void) 
{
	init_onecount_map();
}
