/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef SOMAPLAYER_H
#define SOMAPLAYER_H

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>

#define SOMAPLAYER_PORT		12421

#ifdef __cplusplus
extern "C"
{
#endif

/* The internal struct */
  typedef struct
  {
    int type;
    char *server;
    int port;

    int fd;

  } somaplayer_controller;

/* Open a TCP connection to a somaplayer */
  somaplayer_controller *somaplayer_open_tcp (char *server, int port);

/* Open a UNIX connection to a somaplayer */
  somaplayer_controller *somaplayer_open_unix (char *file);

/* Close the connection */
  int somaplayer_close (somaplayer_controller *);

/* Set the volume 0 - 100 */
  int somaplayer_set_volume (somaplayer_controller *, int);

/* Set the balance 0 - 100 */
  int somaplayer_set_balance (somaplayer_controller *, int);

/* Return the volume 0 - 100 */
  int somaplayer_get_volume (somaplayer_controller *, int *);

/* Return the balance 0 - 100 */
  int somaplayer_get_balance (somaplayer_controller *, int *);

/* Move on the playlist */
  int somaplayer_next (somaplayer_controller *);
  int somaplayer_prev (somaplayer_controller *);

/* Quit the somaplayer */
  int somaplayer_quit (somaplayer_controller *);

/* Pause/Play */
  int somaplayer_pause (somaplayer_controller *);

/* Return this file */
  char *somaplayer_this (somaplayer_controller *);

#ifdef __cplusplus
}
#endif

#endif
