/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "graphic.h"

void
add_file_activate (GtkWidget * w, gpointer data)
{
  GtkWidget *dialog;
  char s[SIZE_BUFFER];

  snprintf (s, SIZE_BUFFER, _("%s %s - Select Files"), NAME, VERSION);

  dialog = gtk_file_chooser_dialog_new (s, GTK_WINDOW (winmain),
					GTK_FILE_CHOOSER_ACTION_OPEN,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					NULL);
  gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog), TRUE);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      struct stat st;
      GSList *l = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (dialog));

      while (l)
	{

	  if (!lstat (l->data, &st) && S_ISREG (st.st_mode))
	    playlist_add (l->data);

	  l = l->next;
	}

      g_slist_free (l);
    }

  gtk_widget_destroy (dialog);
}

/* EOF */
