/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../buffer.h"
#include "graphic.h"
#include "statusbar.h"

char graphic_dialog_text[SIZE_BUFFER];
void timeout_admin_change (void);

int
timeout (gpointer data)
{
  GtkTextIter start;
  GtkTextIter end;
  static int i = 0;
  static int input = INPUT_PLS;
  int input_n = 0;

  if (!text)
    return 1;

  if (events.quit)
    {
      on_quit_activate (NULL, NULL);
      return 0;
    }

  play->go_graphic = 1;

  /* Check input changed */
  input_n = input;

  switch (input)
    {
    case INPUT_PLS:
#ifdef ENABLE_MIC
      if (play->microphone)
	input_n = INPUT_MIC;
#ifdef ENABLE_DAEMON
      else
#endif
#endif
#ifdef ENABLE_DAEMON
      if (play->daemon_input)
	input_n = INPUT_SDS;
#endif
      break;

#ifdef ENABLE_MIC
    case INPUT_MIC:
      if (!play->microphone)
	{
#ifdef ENABLE_DAEMON
	  if (play->daemon_input)
	    input_n = INPUT_SDS;
	  else
#endif
	    input_n = INPUT_PLS;
	}
      break;
#endif

#ifdef ENABLE_DAEMON
    case INPUT_SDS:
      if (!play->daemon_input)
	{
#ifdef ENABLE_MIC
	  if (play->microphone)
	    input_n = INPUT_MIC;
	  else
#endif
	    input_n = INPUT_PLS;
	}
      break;
#endif
    }

  if (input != input_n)
    {
      input = input_n;
      input_update (input);
    }

  /* If admin interface is out */
  if (play->admin)
    timeout_admin_change ();

  /* dialog */
  if (*graphic_dialog_text != 0)
    {
      gtk_dialog_msg (graphic_dialog_text);
      *graphic_dialog_text = 0;
    }

  /* Write on textview */
  pthread_mutex_lock (&gmutex);

  gtk_text_buffer_get_start_iter (GTK_TEXT_BUFFER (text), &start);
  gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER (text), &end);

  gtk_text_buffer_delete (GTK_TEXT_BUFFER (text), &start, &end);

  gtk_text_buffer_get_iter_at_offset (GTK_TEXT_BUFFER (text), &start, 0);

  if (events.pause)
    gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER (text), &start,
					      _("Pause"), -1, "title", NULL);

  else if (events.stop || !play->play)
    gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER (text), &start,
					      _("Stop"), -1, "title", NULL);

  else if (!play->play || !playing ())
    {
      gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER (text),
						&start,
						_("SomaPlayer starting..."),
						-1, "title", NULL);

    }
  else
    {
      char b[SIZE_BUFFER];
      char *utf8;
      int len;

      strncpy (b, playing_file () + i, SIZE_BUFFER);

      len = strlen (b);

      len += 3;

      if (len < SIZE_BUFFER)
	{
	  strcat (b, " - ");

	  strncat (b, playing_file (),
		   i >= SIZE_BUFFER - len ? SIZE_BUFFER - len : i);
	}

      utf8 =
	g_convert (b, strlen (b), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
      gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER (text),
						&start, utf8, -1, "title",
						NULL);
      free (utf8);

      i++;
      if (i > strlen (playing_file ()))
	i = 0;

      gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER (text),
						&start, "\n", -1, "time",
						NULL);

      snprintf (b, SIZE_BUFFER, "\n%s - %d%%",
		play->format_current->get_time (), buffer_perc_size ());

      utf8 =
	g_convert (b, strlen (b), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
      gtk_text_buffer_insert_with_tags_by_name (GTK_TEXT_BUFFER (text),
						&start, utf8, -1, "time",
						NULL);
      free (utf8);

    }

  pthread_mutex_unlock (&gmutex);

  /* Status bar */
  if (play->play && playing ())
    {
      char b[SIZE_BUFFER];
      int k = 0;
      audio *tmp;

      tmp = play->output;

      while (tmp)
	{

	  k++;
	  tmp = tmp->next;
	}

      k = snprintf (b, SIZE_BUFFER, _("%d output%s "), k, k > 1 ? "s" : "");

      k = SIZE_BUFFER - k;

      if (k)
	{
	  if (events.stop)
	    strncat (b, _(" - stop"), k);

	  else if (events.pause)
	    strncat (b, _(" - pause"), k);

	  else if (events.skip)
	    strncat (b, _(" - skip"), k);

	  else
	    strncat (b, _(" - playing"), k);
	}

      msg_statusbar (b);

    }

  sched_yield ();

  return 1;
}

void
timeout_admin_change (void)
{
  GtkAdjustment *adj;

  adj = gtk_range_get_adjustment (GTK_RANGE (element_input->volume));
  if (adj->value != (gdouble) play->volume)
    {
      gtk_adjustment_set_value (adj, play->volume);
    }

  adj = gtk_range_get_adjustment (GTK_RANGE (element_input->balance));
  if (adj->value !=
      (gdouble) ((play->balance + 100) != 0 ? (play->balance + 100) / 2 : 0))
    {
      gtk_adjustment_set_value (adj,
				((play->balance + 100) !=
				 0 ? (play->balance + 100) / 2 : 0));
    }
}

/* EOF */
