/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif
#ifdef ENABLE_DAEMON

#include "../../player.h"
#include "../../output.h"
#include "../../other.h"
#include "../../ftime.h"
#include "../../util.h"
#include "../../sock.h"

void
daemon_input_run (void)
{
  char buf[1024];
  int size;
  int fd;

  fd_set fd_read;
  struct timeval tv;

  format_data_daemon_input *data =
    (format_data_daemon_input *) play->format_current->data;

  if (!data)
    {
      play->daemon_input = 0;
      return;
    }

  play->play = 0;

  data->start = timer_start ();

  if (!(fd = sock_connect (data->sock)))
    {
      play->daemon_input = 0;
      return;
    }

  size = snprintf (buf, sizeof (buf), "MONITOR %d\n", big_endian ());

  if (write (fd, buf, size) < 0)
    {
      msg_error (_("Write error."));
      play->daemon_input = 0;
      return;
    }

  msg (_("Info SdS Input:\n\tType: %s\n\tServer %s\n\tPort %d\n"),
       data->sock->type == SOCKET_TCP ? "tcp" : "unix", data->sock->server,
       data->sock->port);

  output_open (44100, 2, 16);
  output_info ();
  play->play = 1;

  while (1)
    {

      FD_ZERO (&fd_read);
      FD_SET (fd, &fd_read);

      if (events.skip || events.quit)
	break;

      tv.tv_sec = 0;
      tv.tv_usec = 100000;

      size = select (fd + 1, &fd_read, NULL, NULL, &tv);

      if (size < 0)
	{
	  msg_error (_("Read from SdS error."));
	  play->daemon_input = 0;
	  break;
	}

      else if (!size)
	continue;

      if ((size = read (fd, buf, sizeof (buf))) <= 0)
	{
	  msg_error (_("Read from SdS error."));
	  break;
	}

      output_write (buf, size);
    }

  close (fd);

  output_close ();
  play->play = 0;

  timer_clear (data->start);
}

char *
daemon_input_get_time (void)
{
  static char output[13];
  double t;
  long min;
  double sec;
  format_data_daemon_input *data =
    (format_data_daemon_input *) play->format_current->data;

  if (!data)
    return NULL;

  if (!data->start)
    data->start = timer_start ();
  t = timer_time (data->start);

  min = (long) t / (long) 60;
  sec = t - 60.0f * min;

  snprintf (output, 13, "T: %02li:%05.2f", min, sec);

  return output;
}

#endif
