/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "ledbar.h"
#include "output.h"
#include "audio.h"
#ifdef ENABLE_GTK
#include "gtk/graphic.h"
#endif

#define NSAMP 2048
#define BUFS 8
#define LAG 2

void ledbar_levels (void);

static short ledbar_buf[BUFS][NSAMP];
static int ledbar_cur = 0;

/* This 2 functions checks the levels of buffer and updates the ledbars */

void
ledbar_check (void)
{
  static int pos = 0;
  int size;

  size = play->ao_size < NSAMP * 2 - pos ? play->ao_size : NSAMP * 2 - pos;

  memcpy (ledbar_buf[ledbar_cur] + pos, play->ao_buffer, size);

  pos += size;

  if (pos == NSAMP * 2)
    {
      size = 0;
      pos = 0;

      ledbar_levels ();
    }
}

void
ledbar_levels (void)
{
  int buf;
  register int i;
  register short val_l, val_r;
  static unsigned short bigl, bigr;

  ledbar_cur++;

  if (ledbar_cur >= BUFS)
    ledbar_cur = 0;

  buf = ((BUFS * 2) + ledbar_cur - LAG) % BUFS;

  if ((ledbar_cur % 2))
    return;

  bigl = bigr = 0;

  for (i = 0; i < NSAMP / 2; i++)
    {
      val_l = abs (ledbar_buf[ledbar_cur][i]);
      i++;

      val_r = abs (ledbar_buf[ledbar_cur][i]);
      bigl = (val_l > bigl) ? val_l : bigl;
      bigr = (val_r > bigr) ? val_r : bigr;
    }

  bigl /= (NSAMP / 8);
  bigr /= (NSAMP / 8);

  play->ao_left = bigl * 1.27;
  play->ao_right = bigr * 1.27;
}

/* EOF */
