/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#define DEBUG 1

#include <sds.h>

#include <dlfcn.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>

#ifdef HAVE_MACHINE_SOUNDCARD_H
#include <machine/soundcard.h>
#endif
#if HAVE_LINUX_SOUNDCARD_H
#include <linux/soundcard.h>
#endif
#if HAVE_SYS_SOUNDCARD_H
#include <sys/soundcard.h>
#endif
#if HAVE_SOUNDCARD_H
#include <soundcard.h>
#endif
#if HAVE_SYS_AUDIO_H
#include <sys/audio.h>
#endif
#if HAVE_ALSA_SOUNDLIB_H
#include <alsa/soundlib.h>
#endif
#if HAVE_SYS_SOUNDLIB_H
#include <alsa/asoundlib.h>
#endif

#ifndef SIZE_BUFFER
#define SIZE_BUFFER 1024
#endif

#define MMAPEMU_FRAGSTOTAL 16
#define MMAPEMU_FRAGSIZE ESD_BUF_SIZE

#if defined(RTLD_NEXT)
#define REAL_LIBC RTLD_NEXT
#else
#define REAL_LIBC ((void *) -1L)
#endif

/* The preload library */

static int sock_fd = -1;
static int channels = 2, rate = 44100, bitrate = 16;
static int init = 0;

void
msg (char *str, ...)
{
#ifdef DEBUG
  va_list va;

  va_start (va, str);

  fprintf (stderr, "* ");
  vfprintf (stderr, str, va);
  fprintf (stderr, "\n");

  va_end (va);
#endif
}

/* This wrap the open function */
int
open (const char *pathname, int flags, ...)
{
  static int (*func) (const char *, int, mode_t) = NULL;
  va_list args;
  mode_t mode;
  char *server;
  int port = 0;

  if (!func)
    func = (int (*)(const char *, int, mode_t)) dlsym (REAL_LIBC, "open");

  va_start (args, flags);
  mode = va_arg (args, mode_t);
  va_end (args);

  if (!strncmp (pathname, "/dev/", 5)
      && !strncmp (pathname + (strlen (pathname) - 3), "dsp", 3))
    {
      msg ("hijacking /dev/dsp open, and taking it to sds: %s", pathname);

      if ((server = getenv ("SDSHOST")))
	{
	  char *k;

	  k = server;
	  while (*k++)
	    {
	      if (*k == ':')
		{
		  *k = 0;
		  port = atoi (k + 1);
		}
	    }
	}

      sock_fd = sds_open (server, port);
      init = 0;

      return sock_fd;
    }

  else
    return (*func) (pathname, flags, mode);
}

/* dsp control */
static int
dspctl (int fd, int request, void *argp)
{
  int *a = (int *) argp;

  if (fd != sock_fd)
    return -1;

  switch (request)
    {
    case SNDCTL_DSP_RESET:
    case SNDCTL_DSP_POST:
      msg ("hijacking /dev/dsp ioctl no important.");
      break;

    case SNDCTL_DSP_GETOSPACE:
    case SNDCTL_DSP_GETISPACE:
      {
	msg ("hijacking /dev/dsp ioctl - get[i-o]space");
	audio_buf_info *bufinfo = (audio_buf_info *) argp;
	bufinfo->bytes = SIZE_BUFFER;
      }
      break;

    case SNDCTL_DSP_SETFMT:

      msg ("hijacking /dev/dsp ioctl - set bitrate: %d", *a);

      if (*a != 8 && *a != 16)
	return -1;

      bitrate = *a;

      break;

    case SNDCTL_DSP_SPEED:

      msg ("hijacking /dev/dsp ioctl - set rate: %d", *a);

      rate = *a;

      break;

    case SNDCTL_DSP_STEREO:

      msg ("hijacking /dev/dsp ioctl - set channels: %d", *a + 1);

      if (*a)
	channels = 2;
      else
	channels = 1;

      break;

    case SNDCTL_DSP_GETBLKSIZE:
      *a = 4096;
      break;

    case SNDCTL_DSP_GETFMTS:
      *a = 16;
      break;

#ifdef SNDCTL_DSP_GETCAPS
    case SNDCTL_DSP_GETCAPS:
      *a = 0;
      break;
#endif

    default:
      msg ("unhandled /dev/dsp ioctl (%x - %p)", request, argp);
      break;
    }
  return 0;
}

/* IOCTL */
int
ioctl (int fd, int request, ...)
{
  static int (*func) (int, int, void *) = NULL;
  va_list args;
  void *argp;

  if (!func)
    func = (int (*)(int, int, void *)) dlsym (REAL_LIBC, "ioctl");

  va_start (args, request);
  argp = va_arg (args, void *);
  va_end (args);

  if (fd == sock_fd)
    return dspctl (fd, request, argp);

  else
    return (*func) (fd, request, argp);
}

/* Write */
ssize_t
write (int fd, const void *buf, size_t count)
{
  static int (*func) (int, const void *, size_t) = NULL;

  if (!func)
    func = (int (*)(int, const void *, size_t)) dlsym (REAL_LIBC, "write");

  if (fd == sock_fd && !init)
    {
      char str[SIZE_BUFFER];
      int len;

      msg
	("hijacking /dev/dsp write initialize rate: %d - channels %d - bitrate %d",
	 rate, channels, bitrate);

      if (!rate)
	rate = 44100;
      if (!channels)
	channels = 2;
      if (!bitrate)
	bitrate = 16;

      len =
	snprintf (str, SIZE_BUFFER, "%d %d %d\n", rate, channels, bitrate);

      if ((*func) (fd, str, len) != len)
	return -1;

      init++;
    }

  return (*func) (fd, buf, count);
}

/* Close */
int
close (int fd)
{
  static int (*func) (int) = NULL;

  if (!func)
    func = (int (*)(int)) dlsym (REAL_LIBC, "close");

  if (fd == sock_fd)
    {
      sock_fd = -1;

      init = 0;
    }

  return (*func) (fd);
}

/* EOF */
