/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "tty.h"
#include "other.h"
#include "volume.h"
#include "fconfig.h"
#include "format.h"
#include "options.h"
#include "fsignal.h"
#include "daemon.h"
#include "output.h"
#include "admin.h"
#include "bad_list.h"

pthread_t th1, th2;
struct termios t1, t2;

char **arg = NULL;
char **env = NULL;

/* Look here! This mask contains the events of somaplayer. 
 * Quit, Stop, Next, Prev, Play, ... */
event events = { 0, 0, 0, 0
#ifdef ENABLE_GTK
    , 0, 0
#endif
};

somaplayer *play;

int
main (int argc, char *argv[], char *arge[])
{
#ifdef ENABLE_NLS
  setlocale (LC_ALL, "");
  textdomain (PACKAGE);
  bindtextdomain (PACKAGE, LOCALEDIR);
#endif

  msg (_("%s Version: %s - %s\n\n"), NAME, VERSION, AUTHOR_COPYRIGHT);
  msg ("This version of " NAME " is a beta. There is not a stable");
  msg ("version of somaplayer and any debug is realy important for");
  msg ("this project. Send an email to: soma@autistici.org when you");
  msg ("found a bug. Tnx :)\n");

  echo_off ();

  /* The struct! */
  if (!(play = (somaplayer *) malloc (sizeof (somaplayer))))
    fatal (_("Error: memory."));

  arg = argv;
  env = arge;

  memset(play, 0, sizeof(somaplayer));

  /* Active the mutex for the principal list */
  if (pthread_mutex_init (&play->m_list, NULL))
    fatal (_("Error: memory."));
  if (pthread_cond_init (&play->c_list, NULL))
    fatal (_("Error: memory."));

  volume_max ();

#ifdef ENABLE_GTK
  play->size_x = -1;
  play->size_y = -1;
#endif

  play->badlist_timer = BAD_LIST_TIMER;
  play->badlist_max_retry = BAD_MAX_RETRY;

  pthread_mutex_init (&play->m_output, NULL);

  play->bad_list_status = BAD_LIST_NULL;
  pthread_mutex_init (&play->bad_list_mutex, NULL);

#ifdef ENABLE_GTK
  pthread_mutex_init (&play->queue_mutex, NULL);
#endif

  /* Active the list of formats */
  format_init ();

  /* Read the config */
  config_read ();

  /* Parse the parameters */
  if (options (argc, argv))
    quit (1);

  signal (SIGPIPE, signal_pipe);
  signal (SIGSEGV, segfault_handler);

  /* Audio init */
#ifdef ENABLE_AO
  ao_initialize ();
#endif

  /* DAEMON... */
  if (play->daemon)
    daemon_start ();

  /* ... or PLAYER ? */
  else
    {
      signal (SIGINT, signal_handler);

      /* Admin interface */
      if (play->admin)
	if (admin_start ())
	  fatal ("Admin interface error.");

#ifdef ENABLE_GTK
      if (play->graphic && !getenv ("DISPLAY"))
	{
	  msg_error ("No X server running. Starting in text mode!");
	  play->graphic = 0;
	}
#endif

      /* The interface of player is here: */
#ifdef ENABLE_GTK
      if (play->graphic)
	gtk_read ();		/* GTK */
      else
	{
#endif
	  /* Read after ... */
	  if (pthread_create (&th1, NULL, player, NULL))
	    fatal (_("Thread error."));

	  tty_read ();		/* TTY */
#ifdef ENABLE_GTK
	}
#endif
      /* The principal thread (main) is ONLY the interfaces
       * of the player. The other threads are:
       * - the player (TTY runs it now, GTK after)
       * - the buffer (the player runs it because no all type
       of file need the buffer)
       * - the output controllers
       * - other :)
       */

      /* When the interface exits: */
      if (events.quit)
	msg (_("Quitting."));

      events.quit = 1;

#ifdef ENABLE_GTK
      if (!play->graphic)
	{
#endif
	  pthread_cond_signal (&play->p_pop);
	  pthread_join (th1, NULL);
#ifdef ENABLE_GTK
	}
#endif

      echo_on ();
    }

  if (play->admin)
    {
      msg (_("Admin socket closed."));
      pthread_join (play->admin->th, NULL);
    }

  if (play->bad_list_status == BAD_LIST_STOP)
    {
      msg (_("Bad list thread join."));
      pthread_join (play->bad_list_th, NULL);
    }

  msg (_("Free memory."));

  pthread_cond_destroy (&play->p_pop);
  pthread_mutex_destroy (&play->m_output);

  output_exit ();

  format_free ();

#ifdef ENABLE_AO
  ao_shutdown ();
#endif

  free (play);

  msg (_("Done."));

  echo_on ();

  return 0;
}

/* EOF */
