/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "graphic.h"

void
add_file_activate (GtkWidget * w, gpointer data)
{
  char s[SIZE_BUFFER];
  GSList *l, *old;

  snprintf (s, SIZE_BUFFER, _("%s %s - Select Files"), NAME, VERSION);
  if((l=file_chooser(s, GTK_SELECTION_MULTIPLE, GTK_FILE_CHOOSER_ACTION_OPEN)))
    {
      struct stat st;

      old=l;

      while (l)
	{

	  if (!lstat (l->data, &st) && S_ISREG (st.st_mode))
	    playlist_add (l->data);

	  l = l->next;
	}

      g_slist_free (old);
    }
}

void *
file_chooser (char *title, int w, int t)
{
  GtkWidget *dialog;
  static char *path = NULL;
  void *l=NULL;

  dialog = gtk_file_chooser_dialog_new (title, GTK_WINDOW (winmain),
					t,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					NULL);
  if (w==GTK_SELECTION_MULTIPLE)
    gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog), TRUE);
  else
    gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog), FALSE);

  if (!path)
    gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog),
					 g_get_home_dir ());
  else
    gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), path);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      if (w==GTK_SELECTION_MULTIPLE)
	{
	  l = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (dialog));

	  if (path)
	    g_free (path);

	  if (l)
	    path = g_path_get_dirname ((gchar *) ((GSList *)l)->data);
	}
      else
	{
	  l = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	  if (path)
	    g_free (path);

	  if (l) {
	    path = g_path_get_dirname ((gchar *) l);
	  }

	  l=strdup(l);
	}
    }

  gtk_widget_destroy (dialog);
  return l;
}


void
add_dir_activate (GtkWidget * w, gpointer data)
{
  char *dir;
  struct stat st;

  if(!(dir=file_chooser("Select Directories", GTK_SELECTION_SINGLE, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER))) return;

  if (!lstat (dir, &st) && S_ISDIR (st.st_mode))
   playlist_add (dir);
}

/* EOF */
