############################################################################
# conf-macros/sogui.m4
#
# Common macros for the various GUI toolkit libraries for Coin.
#
# Authors:
#   Lars J. Aas <larsa@sim.no>

# SIM_AC_SOGUI_STATIC_DEFAULTS
# ============================
# If --disable-static-defaults is used, do not define WITH_STATIC_DEFAULTS.

AC_DEFUN([SIM_AC_SOGUI_STATIC_DEFAULTS],
[
sim_ac_static_defaults=true;
AC_ARG_ENABLE(
  [static-defaults],
  AC_HELP_STRING([--disable-static-defaults], [Disable defaults from being statically linked in]),
  [case ${enable_static_defaults} in
   no)  sim_ac_static_defaults=false ;;
   yes) ;;
   *)   echo "Option '--enable-static-defaults=${enable_static_defaults}' ignored" ;;
  esac],
  [])

if $sim_ac_static_defaults; then
  AC_DEFINE(WITH_STATIC_DEFAULTS, ,
    [Define this if you want defaults to be linked into SoXt])
fi
])

