<?php
/**
 * Vacation_AliasDriver:: defines an API for implementing vacation backends
 * for the vacation module.
 *
 * $Horde: vacation/lib/AliasDriver.php,v 1.8.2.4 2009/01/06 15:28:06 jan Exp $
 *
 * Copyright 2004-2009 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * @author  Jason M. Felice <jason.m.felice@gmail.com>
 * @package Vacation
 */
class Vacation_AliasDriver {

    /**
     * The current user name.
     *
     * @var string
     */
    var $_user;

    /**
     * Hash containing configuration data.
     *
     * @var array
     */
    var $_params;

    /**
     * Constructor
     *
     * @param string $user   A user name.
     * @param array $params  Configuration parameters for the backend.
     */
    function Vacation_AliasDriver($user, $params = array())
    {
        $this->_user = $user;
        $this->_params = $params;
    }

    /**
     * Retrieve the aliases.
     *
     * @return mixed A key/value array of aliases (the right-hand side is
     *               arrays), or PEAR_Error on failure.
     */
    function getAliases()
    {
        return PEAR::raiseError(_("Not implemented."));
    }

    /**
     * Figure out which aliases are for this user.
     *
     * Here we find all aliases which have only the specified user on the
     * right-hand-side (if there are more, it is assumed to be a list).
     *
     * @return mixed  An array of the aliases, or PEAR_Error on failure.
     */
    function getAliasesForUser()
    {
        $aliases = $this->getAliases();
        if (is_a($aliases, 'PEAR_Error')) {
            return $aliases;
        }

        $result = array();
        foreach ($aliases as $src => $targets) {
            if (count($targets) == 1 && $targets[0] == $this->_user) {
                $result[] = $src;
            }
        }

        return $result;
    }

    /**
     * Creates a concrete Vacation_AliasDriver:: instance.
     *
     * @param string $user    A user name.
     * @param string $driver  The type of concrete Vacation_AliasDriver
     *                        subclass to return.
     * @param array $params   A hash containing any additional configuration or
     *                        connection parameters a subclass might need.
     *
     * @return mixed  The newly created concrete Vacation_AliasDriver instance,
     *                or false on error.
     */
    function factory($user, $driver = null, $params = null)
    {
        if (is_null($driver)) {
            $driver = $GLOBALS['conf']['aliases']['driver'];
        }

        $driver = basename($driver);

        if (is_null($params)) {
            $params = Horde::getDriverConfig('aliases', $driver);
        }

        require_once dirname(__FILE__) . '/AliasDriver/' . $driver . '.php';
        $class = 'Vacation_AliasDriver_' . $driver;
        if (class_exists($class)) {
            $alias = new $class($user, $params);
        } else {
            $alias = false;
        }

        return $alias;
    }

}
