

#ifndef _CALIBRATE_H_
#define _CALIBRATE_H_

#include <kprocess.h>

#include <qobject.h>
#include <qdatetime.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class QString;
class KTempFile;

/**
 * @short Calibrate
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class Calibrate : public QObject
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Calibrate();

    /**
     * Default Destructor
     */
    virtual ~Calibrate();

public slots:
    void start(QString,QString);
    void cancel();

signals:
    void exited(int);

private:
    KProcess pPrepare;
    KProcess pEncode;
    KProcess pDecode;
    KProcess pReplayGain;
    QTime time;
    int length;
    QString format;
    QString file;
    QString tempOriFile;
    QString tempEncFile;
    QString tempDecFile;
    KTempFile *kTempOriFile;
    KTempFile *kTempEncFile;
    KTempFile *kTempDecFile;
    bool reverse;
    bool bCanceled;
    QString procOutput;
    QString procParam;

    void encode();
    void decode();
    void replayGain();
    void cleanUp();

private slots:
    void prepareExit(KProcess*);
    void encodeExit(KProcess*);
    void decodeExit(KProcess*);
    void replayGainExit(KProcess*);
    void processOutput(KProcess*,char*,int);

};

#endif // _CALIBRATE_H_
