
#ifndef _CONFIG_DIALOGUE_BACKEND_PLUGINS_H_
#define _CONFIG_DIALOGUE_BACKEND_PLUGINS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

#include <kio/jobclasses.h>

class KPushButton;
class QListBox;
class QCheckBox;

/**
 * @short ConfigDialogueBackendPlugins
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ConfigDialogueBackendPlugins : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigDialogueBackendPlugins( QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigDialogueBackendPlugins();

private:
    QListBox *lPlugins;
    KPushButton *pAddPlugin;
    KPushButton *pRemovePlugin;
    KPushButton *pAboutPlugin;
    KPushButton *pDownloadPlugins;
    QListBox *lOnlinePlugins;
    KPushButton *pRefreshPlugins;
    KPushButton *pInstallPlugin;
    KPushButton *pAboutOnlinePlugin;
    KIO::FileCopyJob *refreshPluginsJob;
    KIO::FileCopyJob *getPluginInfoJob;
    KIO::FileCopyJob *installPluginJob;
    KIO::FileCopyJob *addPluginJob;
    QCheckBox *cCheckOnlinePlugins;

public slots:
    void resetDefaults();
    void saveSettings();

signals:
    void configChanged();
    void recalcEnDecoderPage();
    void reloadEnDecoderPage();
    void rescanForBackends();

private slots:
    void cfgChanged();
    void addPlugin();
    void removePlugin();
    void showPluginInfo();
    void refreshPlugins();
    void getPluginInfo();
    void installPlugin();
    void refreshFinished(KIO::Job*);
    void getInfoFinished(KIO::Job*);
    void installFinished(KIO::Job*);
    void addFinished(KIO::Job*);
    void pluginsSelectionChanged(int);
    void onlinePluginsSelectionChanged(int);

protected:
    void dropEvent(QDropEvent*);
    void dragEnterEvent(QDragEnterEvent*);

};

#endif // _CONFIG_DIALOGUE_BACKEND_PLUGINS_H_

