
#include "config_dialogue_en_decoder_options.h"
#include "config_defaults.h"

#include "backend_plugins.h"

#include <qlabel.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qslider.h>
#include <qtooltip.h>
#include <qscrollview.h>
#include <qvbox.h>

#include <kconfig.h>
#include <klocale.h>

StrengthOptions::StrengthOptions()
{
}

StrengthOptions::StrengthOptions(QString e)
{
    encoder=e;
}

StrengthOptions::~StrengthOptions()
{
}

ConfigDialogueEnDecoderOptions::ConfigDialogueEnDecoderOptions( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    QGridLayout *grid = new QGridLayout( this );
    QScrollView* sv = new QScrollView( this, "sv" );
    sv->setResizePolicy(QScrollView::AutoOneFit);
    grid->addWidget(sv,0,0);
    QVBox *box = new QVBox( sv->viewport() );
    box->setMargin(10);
    box->setSpacing(5);
    sv->addChild(box);

    int row=0,strength;

    for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it )
    {
        if( !(*it).enc.enabled || !(*it).enc.strength.enabled ) continue;

        StrengthOptionsList::Iterator options=strengthOptions.append(StrengthOptions((*it).enc.bin));

        (*options).group = new QGroupBox((*options).encoder,box,"group");
        (*options).group->setColumnLayout(0,Qt::Vertical);
        (*options).group->layout()->setSpacing(5);
        (*options).group->layout()->setMargin(10);

        (*options).topGrid = new QGridLayout((*options).group->layout());

        /*if( (*options).encoder == "lame" ) {
            cCRC = new QCheckBox(i18n("CRC error protection"),(*options).group,"cCRC");
            cCRC->setChecked(prefs.convert.mp3CrcCheck);
            QToolTip::add(cCRC,i18n("This option adds CRC error protection to the encoded mp3 files.\nThis will reduce the sound quality so you should only use it, if you know what you are doing."));
            (*options).topGrid->addWidget(cCRC,0,0);
            connect(cCRC,SIGNAL(toggled(bool)),this,SLOT(cfgChanged()));
            cISO = new QCheckBox(i18n("Strictly enforce ISO"),(*options).group,"cISO");
            cISO->setChecked(prefs.convert.mp3ISO);
            QToolTip::add(cISO,i18n("This option limitates the total frame size to 7680 bits.\nThis might waste a lot of space.\nThis compatibility might be important for hardware players."));
            (*options).topGrid->addWidget(cISO,1,0);
            connect(cISO,SIGNAL(toggled(bool)),this,SLOT(cfgChanged()));
            row+=2;
        }*/

        (*options).lStrength = new QLabel(i18n("Compression level")+":",(*options).group,"lStrength");
        (*options).topGrid->addWidget((*options).lStrength,row,0);

        (*options).grid = new QGridLayout((*options).group->layout());
        for( FileFormatList::Iterator jt=prefs.fileFormatList.begin(); jt!=prefs.fileFormatList.end(); ++jt )
        {
            if( (*jt).encoder == (*options).encoder ) strength=(int)(*jt).compressionLevel;
        }
        if( (*it).enc.strength.range_max >= (*it).enc.strength.range_min ) {
            (*options).sStrength = new QSlider( (int)((*it).enc.strength.range_min/(*it).enc.strength.step),(int)((*it).enc.strength.range_max/(*it).enc.strength.step),1,strength,Qt::Horizontal,(*options).group,"sStrength" );
        }
        else {
            (*options).sStrength = new QSlider( (int)((*it).enc.strength.range_max/(*it).enc.strength.step),(int)((*it).enc.strength.range_min/(*it).enc.strength.step),1,strength,Qt::Horizontal,(*options).group,"sStrength" );
        }
        (*options).sStrength->setTickmarks(QSlider::Below);
        QToolTip::add((*options).sStrength,i18n("Set if the backend should use a good algorithm for encoding (smaller file size),\nor a fast (faster encoding).\nYou should recalibrate your encoder after changing this."));
        (*options).topGrid->addWidget((*options).sStrength,row+1,0);
        connect((*options).sStrength,SIGNAL(valueChanged(int)),this,SLOT(cfgChanged())); (*options).lStrengthInfoLeft = new QLabel(i18n("Fast"),(*options).group,"lStrengthInfoLeft");
        (*options).lStrengthInfoLeft->setAlignment(Qt::AlignLeft);
        (*options).grid->addWidget((*options).lStrengthInfoLeft,row+1,0);
        (*options).lStrengthInfoRight = new QLabel(i18n("Good"),(*options).group,"lStrengthInfoRight");
        (*options).lStrengthInfoRight->setAlignment(Qt::AlignRight);
        (*options).grid->addWidget((*options).lStrengthInfoRight,row+1,1);
    }

    /*if( row == 0 ) {
        cCRC = new QCheckBox(i18n("CRC error protection"),this,"cCRC");
        cCRC->setChecked(prefs.convert.mp3CrcCheck);
        cCRC->hide();
        cISO = new QCheckBox(i18n("Strictly enforce ISO"),this,"cISO");
        cISO->setChecked(prefs.convert.mp3ISO);
        cISO->hide();
    }*/
}

ConfigDialogueEnDecoderOptions::~ ConfigDialogueEnDecoderOptions()
{
}

void ConfigDialogueEnDecoderOptions::cfgChanged()
{
    emit configChanged();
}

void ConfigDialogueEnDecoderOptions::resetDefaults()
{
    //cCRC->setChecked(DEFAULT_MP3_CRC_CHECK);
    //cISO->setChecked(DEFAULT_MP3_ISO);
}

void ConfigDialogueEnDecoderOptions::saveSettings()
{
    //prefs.convert.mp3CrcCheck=cCRC->isChecked();
    //prefs.convert.mp3ISO=cISO->isChecked();

    for( StrengthOptionsList::Iterator it=strengthOptions.begin(); it!=strengthOptions.end(); ++it )
    {
        for( FileFormatList::Iterator jt=prefs.fileFormatList.begin(); jt!=prefs.fileFormatList.end(); ++jt )
        {
            if( (*jt).encoder == (*it).encoder ) {
                (*jt).compressionLevel=(*it).sStrength->value();
            }
        }
    }
}

