

#ifndef _CONVERT_H_
#define _CONVERT_H_

#include <kprocess.h>

#include <qobject.h>
#include <qdatetime.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * @short Convert
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class Convert : public QObject
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Convert();

    /**
     * Default Destructor
     */
    virtual ~Convert();

public slots:
    void encode();
    void decode();
    void replayGain();
    void kill();
    void priorityChanged(int);

signals:
    void updateStatus();
    void exited(int);
    void sendOutput(QString);
    void timeConverted(float);

private:
    KProcess pEncode;
    KProcess pDecode;
    KProcess pReplayGain;
    QTime pauseTime;
    QTime lastSignal;
    bool bKilled;
    int priority;
    QString lastOutput;

    void cleanUp();

private slots:
    void encodeOutput(KProcess*,char*,int);
    void encodeExit(KProcess*);
    void decodeOutput(KProcess*,char*,int);
    void decodeExit(KProcess*);
    void replayGainOutput(KProcess*,char*,int);
    void replayGainExit(KProcess*);

};

#endif // _CONVERT_H_
