
#include "firstrunwizard.h"

#include "config_dialogue_backend_plugins.h"
#include "config_dialogue_backends.h"
#include "config_dialogue_en_decoder.h"

#include <qgrid.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qfont.h>
#include <qimage.h>

#include <klocale.h>
#include <kstandarddirs.h>

FirstRunWizard::FirstRunWizard(QWidget *parent, const char *name)
    : KWizard(parent, name)
{
    QGrid *gStart = new QGrid(1,this);
    gStart->setSpacing(10);
    QLabel *lStart = new QLabel(i18n("soundKonverter is a frontend to various audio converters.\nYou can extend soundKonverter with plugins. This way a lot of audio converters and as a result a lot of audio formats are supported. With this assistant you are able to download the latest plugins, audio converters and set them up.\nBy default, most popular plugins are shipped with soundKonverter, so you may skip this assistant.\n\nI wish all of you a lot of fun with soundKonverter, please report every bug!"),gStart);
    QLabel *lStartImg = new QLabel(gStart);
    KStandardDirs *stdDirs = new KStandardDirs();
    QImage *image = new QImage(stdDirs->findResource("data","soundkonverter/pics/welcome.png"));
    lStartImg->setPixmap(*image);
    lStart->setAlignment(QLabel::WordBreak|QLabel::AlignTop);
    //lStart->setMaximumWidth(600);
    addPage(gStart,i18n("Welcome to soundKonverter")+" 0.2 rc2");

    gBackendPlugins = new QGrid(2,this);
    gBackendPlugins->setSpacing(10);
    QLabel *lBackendPlugins = new QLabel(i18n("On the right side you can see a listbox at the top. Here all installed plugins are shown. You may add new plugins here if you have some. You may also remove unneeded plugins (may be reinstalled any time), but this is not recommended.\n\nAt the bottom you can see another listbox, where all plugins are shown, that are available via download. You may click on \"Refresh\" to list all available plugins (a working internet connection is required). Then select the plugin you want to install an click on \"Install\" button."),gBackendPlugins);
    lBackendPlugins->setAlignment(QLabel::WordBreak|QLabel::AlignTop);
    lBackendPlugins->setMaximumWidth(300);
    dBackendPlugins = new ConfigDialogueBackendPlugins(gBackendPlugins,"dBackendPlugins");
    addPage(gBackendPlugins,i18n("Backend Plugins (1 of 3)"));
    connect(this,SIGNAL(saveBackendPlugins()),dBackendPlugins,SLOT(saveSettings()));

    gBackends = new QGrid(2,this);
    gBackends->setSpacing(10);
    QLabel *lBackends = new QLabel(i18n("On the right side you can see a listbox at the top. Here all paths are listed that are scanned for audio converters, used by soundKonverter. You may add additional paths here. You may also remove unneeded (not recommended)\n\nIn the middle you can see all audio converters that were found.\n\nAt the bottom you can see another listbox, where all audio converters are shown, that are available via download. You may click on \"Refresh\" to list all available converters (a working internet connection is required). Then select the converter you want to install and click on \"Install\" button."),gBackends);
    lBackends->setAlignment(QLabel::WordBreak|QLabel::AlignTop);
    lBackends->setMaximumWidth(300);
    dBackends = new ConfigDialogueBackends(gBackends,"dBackends");
    addPage(gBackends,i18n("Backends (2 of 3)"));
    connect(dBackendPlugins,SIGNAL(rescanForBackends()),dBackends,SLOT(rescan()));
    connect(this,SIGNAL(rescanForBackends()),dBackends,SLOT(rescan()));
    connect(this,SIGNAL(saveBackends()),dBackends,SLOT(saveSettings()));

    gEnDecoder = new QGrid(2,this);
    gEnDecoder->setSpacing(10);
    QLabel *lEnDecoder = new QLabel(i18n("If you want, you can now select an audio file and calibrate all your successful configured audio converters. Just click on \"Calibrate\" and wait a few seconds (the duration of the calibrating progress depends on the power of your pc).\n\nYou may also skip this step. In this case standard values are saved and the progress bar may not be that nice."),gEnDecoder);
    lEnDecoder->setAlignment(QLabel::WordBreak|QLabel::AlignTop);
    lEnDecoder->setMaximumWidth(300);
    dEnDecoder = new ConfigDialogueEnDecoder(gEnDecoder,"dEnDecoder");
    addPage(gEnDecoder,i18n("En, Decoder (3 of 3)"));
    connect(this,SIGNAL(saveEnDecoder()),dEnDecoder,SLOT(saveSettings()));

    connect(dBackendPlugins,SIGNAL(recalcEnDecoderPage()),dEnDecoder,SLOT(recalc()));
    connect(dBackends,SIGNAL(recalcEnDecoderPage()),dEnDecoder,SLOT(recalc()));
    connect(dBackendPlugins,SIGNAL(reloadEnDecoderPage()),dEnDecoder,SLOT(reload()));

    helpButton()->hide();
    setFinishEnabled(gEnDecoder,true);
    QFont *title = new QFont();
    title->setBold(true);
    setTitleFont(*title);

    connect(finishButton(),SIGNAL(clicked()),this,SLOT(finish()));
    cancelButton()->setText(i18n("Skip"));
    connect(nextButton(),SIGNAL(clicked()),this,SLOT(nextClicked()));
    connect(cancelButton(),SIGNAL(clicked()),this,SLOT(autoConfig()));

    resize(QSize(gBackends->sizeHint().width()+200,gBackends->sizeHint().height()+200));

    emit rescanForBackends();
}

FirstRunWizard::~FirstRunWizard()
{
}

void FirstRunWizard::finish()
{
    emit saveBackendPlugins();
    emit saveBackends();
    emit saveEnDecoder();

    prefs.write();
}

void FirstRunWizard::autoConfig()
{
    // TODO komplett konfigurieren
    emit rescanForBackends();
    emit recalcEnDecoderPage();

    emit saveBackendPlugins();
    emit saveBackends();
    emit saveEnDecoder();

    prefs.write();
}

void FirstRunWizard::nextClicked()
{
    cancelButton()->setText(i18n("Cancel"));
}

