
#ifndef _FIRSTRUNWIZARD_H_
#define _FIRSTRUNWIZARD_H_

#include "config.h"

#include <kwizard.h>

class ConfigDialogueBackendPlugins;
class ConfigDialogueBackends;
class ConfigDialogueEnDecoder;

class QGrid;

/**
 * @short FirstRunWizard
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class FirstRunWizard : public KWizard
{
    Q_OBJECT
public:
    FirstRunWizard(QWidget *parent = 0, const char *name = 0);

    virtual ~FirstRunWizard();

private:
    QGrid *gBackendPlugins;
    QGrid *gBackends;
    QGrid *gEnDecoder;

    ConfigDialogueBackendPlugins *dBackendPlugins;
    ConfigDialogueBackends *dBackends;
    ConfigDialogueEnDecoder *dEnDecoder;

    void setConfigChanged(const bool);

signals:
    void saveBackendPlugins();
    void saveBackends();
    void saveEnDecoder();

    void recalcEnDecoderPage();
    void rescanForBackends();

private slots:
    void finish();
    void autoConfig();
    void nextClicked();

};

#endif // _FIRSTRUNWIZARD_H_
