

#include "options_detailed.h"
#include "config.h"
#include "backend_plugins.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
//#include <qpushbutton.h>
#include <qstringlist.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <klocale.h>

OptionsDetailed::OptionsDetailed( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    QGridLayout *grid = new QGridLayout( this, 2, 1, 10, 5 );

    QHBoxLayout *topBox = new QHBoxLayout( );
    grid->addLayout( topBox, 0, 0 );

    lConvert = new QLabel( i18n("Convert")+":", this, "lConvert" );
    topBox->addWidget( lConvert, 0, Qt::AlignVCenter );
    cFormat = new QComboBox( this, "cFormat" );
    cFormat->clear();
    sFormat=backendPlugins.allFileFormats();
    cFormat->insertStringList(sFormat);
    cFormat->insertItem( "wav" );
    sFormat.append( "wav" );
    topBox->addWidget( cFormat, 0, Qt::AlignVCenter );
    cQualityMode = new QComboBox( this, "cQualityMode" );
    cQualityMode->insertItem( i18n("Quality") );
    //sQualityMode.append( i18n("Quality") );
    cQualityMode->insertItem( i18n("Bitrate") );
    //sQualityMode.append( i18n("Bitrate") );
    cQualityMode->insertItem( i18n("Lossless") );
    cQualityMode->insertItem( i18n("Undefined") );
    cQualityMode->setFixedSize(cQualityMode->sizeHint());
    //cQualityMode->removeItem(2);
    //cQualityMode->removeItem(2);
    topBox->addWidget( cQualityMode, 0, Qt::AlignVCenter );
    sQuality = new QSpinBox( this, "sQuality" );
    QToolTip::add( sQuality, i18n("This is a relative quality between 0 and 100.\nThe higher this number the higher is the quality.\nsoundKonverter will convert it into the file format's quality format.\nSee the \"What's this?\" for more informations.") );
    topBox->addWidget( sQuality, 0, Qt::AlignVCenter );
    cBitrateMode = new QComboBox( this, "cBitrateMode" );
    QToolTip::add( cBitrateMode, i18n("vbr - variable bit rate\nabr - average bit rate\ncbr - constant bit rate") );
    topBox->addWidget( cBitrateMode, 0, Qt::AlignVCenter );
    topBox->addSpacing( 10 );

    cBitrateRange = new QCheckBox( i18n("Bitrate range")+":", this, "cBitrateRange" );
    QToolTip::add( cBitrateRange, i18n("Use it only if you know what you are doing, you could reduce the quality.") );
    topBox->addWidget( cBitrateRange, 0, Qt::AlignVCenter );
    sMinBitrate = new QSpinBox( this, "sMinBitrate" );
    sMinBitrate->setMinValue( 32 );
    sMinBitrate->setMaxValue( 320 );
    sMinBitrate->setLineStep( 8 );
    sMinBitrate->setValue( 64 );
    topBox->addWidget( sMinBitrate, 0, Qt::AlignVCenter );
    lBitrateRangeTo = new QLabel( "-", this, "lBitrateRangeTo" );
    topBox->addWidget( lBitrateRangeTo, 0, Qt::AlignVCenter );
    sMaxBitrate = new QSpinBox( this, "sMaxBitrate" );
    sMaxBitrate->setMinValue( 32 );
    sMaxBitrate->setMaxValue( 320 );
    sMaxBitrate->setLineStep( 8 );
    sMaxBitrate->setValue( 192 );
    topBox->addWidget( sMaxBitrate, 0, Qt::AlignVCenter );
    lBitrateRangeUnit = new QLabel( "kbps", this, "lBitrateRangeUnit" );
    topBox->addWidget( lBitrateRangeUnit, 0, Qt::AlignVCenter );
    topBox->addStretch( );

    QHBoxLayout *bottomBox = new QHBoxLayout( );
    grid->addLayout( bottomBox, 1, 0 );

    cResample = new QCheckBox( i18n("Resample")+":", this, "cResample" );
    bottomBox->addWidget( cResample, 0, Qt::AlignVCenter );
    cSampleRate = new QComboBox( this, "cSampleRate" );
    cSampleRate->setEditable(true);
    cSampleRate->insertItem("48000");
    cSampleRate->insertItem("44100");
    cSampleRate->insertItem("32000");
    cSampleRate->insertItem("24000");
    cSampleRate->insertItem("22050");
    cSampleRate->insertItem("16000");
    cSampleRate->insertItem("12000");
    cSampleRate->insertItem("11025");
    cSampleRate->insertItem("8000");
    cSampleRate->setCurrentText("44100");
    bottomBox->addWidget( cSampleRate, 0, Qt::AlignVCenter );
    lSampleRateUnit = new QLabel( "Hz", this, "lSampleRateUnit" );
    bottomBox->addWidget( lSampleRateUnit, 0, Qt::AlignVCenter );
    bottomBox->addSpacing( 10 );

    cChannels = new QCheckBox( i18n("Channels")+":", this, "cChannels" );
    bottomBox->addWidget( cChannels, 0, Qt::AlignVCenter );
    cNumChannels = new QComboBox( this, "cNumChannels" );
    cNumChannels->insertItem( i18n("Mono") );
    sNumChannels.append( i18n("Mono") );
    cNumChannels->insertItem( i18n("Stereo") );
    sNumChannels.append( i18n("Stereo") );
    bottomBox->addWidget( cNumChannels, 0, Qt::AlignVCenter );
    bottomBox->addStretch( );
    bottomBox->addSpacing( 10 );

    cReplayGain = new QCheckBox( i18n("ReplayGain"), this, "cReplayGain" );
    cReplayGain->setChecked(true);
    QToolTip::add( cReplayGain, i18n("Add a ReplayGain tag to the converted file.") );
    QWhatsThis::add( cReplayGain, i18n("ReplayGain is a volume correction technique. A volume difference is calculated and stored in a tag. This way audio players can automatically adjust the volume and the original music data is not modified (like at normalization).") );
    bottomBox->addWidget( cReplayGain, Qt::AlignLeft, Qt::AlignVCenter );

    formatChanged();

    /*pMoreOptions = new QPushButton( i18n("More..."), this, "pMoreOptions" );
    bottomBox->addWidget( pMoreOptions, 0, Qt::AlignVCenter );
    */
    connect( cFormat, SIGNAL(activated(int)),
             this, SLOT(formatChanged()) );
    connect( cQualityMode, SIGNAL(activated(int)),
             this, SLOT(qualityModeChanged()) );
    connect( cBitrateMode, SIGNAL(activated(int)),
             this, SLOT(bitrateModeChanged()) );
    connect( cBitrateRange, SIGNAL(toggled(bool)),
             this, SLOT(bitrateRangeToggled()) );
    connect( cResample, SIGNAL(toggled(bool)),
             this, SLOT(resampleToggled()) );
    connect( cChannels, SIGNAL(toggled(bool)),
             this, SLOT(channelsToggled()) );

    /*connect( pMoreOptions, SIGNAL(clicked()),
             this, SLOT(moreOptionsClicked()) );
    */
}

OptionsDetailed::~OptionsDetailed()
{
}

int OptionsDetailed::formatIndex( QString string )
{
    return sFormat.findIndex( string );
}

int OptionsDetailed::qualityModeIndex( QString string )
{
    return sQualityMode.findIndex( string );
}

int OptionsDetailed::bitrateModeIndex( QString string )
{
    return sBitrateMode.findIndex( string );
}

int OptionsDetailed::numChannelsIndex( QString string )
{
    return sNumChannels.findIndex( string );
}

void OptionsDetailed::formatChanged()
{
    if( cFormat->currentText() == "wav" ) {
        cReplayGain->setEnabled( false );
        cQualityMode->clear();
        sQualityMode.clear();
        cQualityMode->insertItem( i18n("Lossless") );
        sQualityMode.append( i18n("Lossless") );
        qualityModeChanged();
        return;
    }

    BackendPlugins::PluginStructure plugin=backendPlugins.plugin( prefs.fileFormat(cFormat->currentText()).encoder );
    QString last;

    last=cQualityMode->currentText();
    cQualityMode->clear();
    sQualityMode.clear();

    if( plugin.enc.replaygain.enabled || prefs.fileFormat(cFormat->currentText()).replaygain != "" ) cReplayGain->setEnabled( true );
    else cReplayGain->setEnabled( false );

    if( plugin.enc.lossy.enabled ) {
        if( plugin.enc.quality.enabled ) {
            cQualityMode->insertItem( i18n("Quality") );
            sQualityMode.append( i18n("Quality") );
        }
        if( plugin.enc.bitrate.abr.enabled || plugin.enc.bitrate.cbr.enabled ) {
            cQualityMode->insertItem( i18n("Bitrate") );
            sQualityMode.append( i18n("Bitrate") );
        }
        if( !plugin.enc.quality.enabled && !plugin.enc.bitrate.abr.enabled && !plugin.enc.bitrate.cbr.enabled ) {
            cQualityMode->insertItem( i18n("Unchanged") );
            sQualityMode.append( i18n("Unchanged") );
        }
    }
    if( plugin.enc.lossless.enabled ) {
        cQualityMode->insertItem( i18n("Lossless") );
        sQualityMode.append( i18n("Lossless") );
    }
    if( !plugin.enc.lossy.enabled && !plugin.enc.lossless.enabled ) {
        cQualityMode->insertItem( i18n("Undefined") );
        sQualityMode.append( i18n("Undefined") );
    }
    cQualityMode->setCurrentItem( qualityModeIndex(last) );
    qualityModeChanged();
}

void OptionsDetailed::qualityModeChanged()
{
    QWhatsThis::remove( sQuality );

    if( cFormat->currentText() == "wav" ) {
        sQuality->setEnabled( false );
        cBitrateMode->setEnabled( false );
        cBitrateRange->setEnabled( false );
        sMinBitrate->setEnabled( false );
        lBitrateRangeTo->setEnabled( false );
        sMaxBitrate->setEnabled( false );
        lBitrateRangeUnit->setEnabled( false );
        cResample->setEnabled( false );
        cSampleRate->setEnabled( false );
        lSampleRateUnit->setEnabled( false );
        cChannels->setEnabled( false );
        cNumChannels->setEnabled( false );
        return;
    }

    QString qualityModeString=cQualityMode->currentText();
    QString last;
    int lastValue;
    BackendPlugins::PluginStructure plugin=backendPlugins.plugin( prefs.fileFormat(cFormat->currentText()).encoder );

    if( lastQualityMode != qualityModeString ) {
        lastValue=0;
        lastQualityMode=qualityModeString;
    }
    else {
        lastValue=sQuality->value();
    }

    if( qualityModeString != i18n("Lossless") ) {
        bitrateRangeToggled();
        if( plugin.enc.resample.enabled ) cResample->setEnabled( true );
        else cResample->setEnabled( false );
        resampleToggled();
        if( plugin.enc.channels.mono_enabled || plugin.enc.channels.stereo_enabled ) {
            cChannels->setEnabled( true );
            last=cNumChannels->currentText();
            cNumChannels->clear();
            sNumChannels.clear();
            if( plugin.enc.channels.mono_enabled ) {
                cNumChannels->insertItem( i18n("Mono") );
                sNumChannels.append( i18n("Mono") );
            }
            if( plugin.enc.channels.stereo_enabled ) {
                cNumChannels->insertItem( i18n("Stereo") );
                sNumChannels.append( i18n("Stereo") );
            }
            cNumChannels->setCurrentItem( numChannelsIndex(last) );
        }
        else cChannels->setEnabled( false );
        channelsToggled();
    }

    if( qualityModeString == i18n("Bitrate") ) {
        sQuality->setEnabled( true );
        sQuality->setMinValue( 32 );
        sQuality->setMaxValue( 320 );
        sQuality->setLineStep( 8 );
        if( lastValue != 0 ) sQuality->setValue( lastValue );
        else sQuality->setValue( 128 );
        cBitrateMode->setEnabled( true );
        last = cBitrateMode->currentText();
        cBitrateMode->clear();
        sBitrateMode.clear();
        if( plugin.enc.bitrate.abr.enabled ) {
            cBitrateMode->insertItem( "abr" );
            sBitrateMode.append( "abr" );
        }
        if( plugin.enc.bitrate.cbr.enabled ) {
            cBitrateMode->insertItem( "cbr" );
            sBitrateMode.append( "cbr" );
        }
        cBitrateMode->setCurrentItem( bitrateModeIndex(last) );
        bitrateModeChanged();
    }
    else if( qualityModeString == i18n("Quality") ) {
        sQuality->setEnabled( true );
        sQuality->setMinValue( 0 );
        sQuality->setMaxValue( 100 );
        sQuality->setLineStep( 5 );
        if( lastValue != 0 ) sQuality->setValue( lastValue );
        else sQuality->setValue( 40 );
        cBitrateMode->setEnabled( true );
        cBitrateMode->clear();
        sBitrateMode.clear();
        cBitrateMode->insertItem( "vbr" );
        sBitrateMode.append( "vbr" );
        bitrateModeChanged();

        if( plugin.enc.quality.help ) {
            QString str = plugin.enc.quality.help;
            str.replace("\\n","<br>");
            QWhatsThis::add( sQuality, "<p>"+str+"</p>" );
        }

/*      "ogg" "<p>0 ~ -1.0<br>10 ~ 0.1<br>20 ~ 1.2<br>30 ~ 2.3<br>40 ~ 3.4<br>50 ~ 4.5<br>60 ~ 5.6<br>70 ~ 6.7<br>80 ~ 7.8<br>90 ~ 8.9<br>100 ~ 10.0<br></p>"
        "mp3" "<p>0 ~ 9<br>10 ~ 8<br>20 ~ 7<br>30 ~ 6<br>40 ~ 5<br>50 ~ 5<br>60 ~ 4<br>70 ~ 3<br>80 ~ 2<br>90 ~ 1<br>100 ~ 0<br></p>"
        "mpc" "<p>0 ~ 0.0 ~ below telephone<br>10 ~ 1.0 ~ below telephone<br>20 ~ 2.0 ~ telephone<br>30 ~ 3.0 ~ thumb<br>40 ~ 4.0 ~ radio<br>50 ~ 5.0 ~ standard<br>60 ~ 6.0 ~ xtreme<br>70 ~ 7.0 ~ insane<br>80 ~ 8.0 ~ braindead<br>90 ~ 9.0 ~ above braindead<br>100 ~ 10.0 ~ above braindead<br></p>"
*/
    }
    else if( qualityModeString == i18n("Lossless") || qualityModeString == i18n("Undefined") ) {
        sQuality->setEnabled( false );
        cBitrateMode->setEnabled( false );
        cBitrateRange->setEnabled( false );
        sMinBitrate->setEnabled( false );
        lBitrateRangeTo->setEnabled( false );
        sMaxBitrate->setEnabled( false );
        lBitrateRangeUnit->setEnabled( false );
        cResample->setEnabled( false );
        cSampleRate->setEnabled( false );
        lSampleRateUnit->setEnabled( false );
        cChannels->setEnabled( false );
        cNumChannels->setEnabled( false );
    }
    else if( qualityModeString == i18n("Unchanged") ) {
        sQuality->setEnabled( false );
        cBitrateMode->setEnabled( false );
        cBitrateRange->setEnabled( false );
        sMinBitrate->setEnabled( false );
        lBitrateRangeTo->setEnabled( false );
        sMaxBitrate->setEnabled( false );
        lBitrateRangeUnit->setEnabled( false );
    }
}

void OptionsDetailed::bitrateModeChanged()
{
    BackendPlugins::PluginStructure plugin=backendPlugins.plugin( prefs.fileFormat(cFormat->currentText()).encoder );

    if( cBitrateMode->currentText() == "abr" && plugin.enc.bitrate.abr.bitrate_range.enabled ) {
        cBitrateRange->setEnabled( true );
        bitrateRangeToggled();
    }
    else {
        cBitrateRange->setEnabled( false );
        sMinBitrate->setEnabled( false );
        lBitrateRangeTo->setEnabled( false );
        sMaxBitrate->setEnabled( false );
        lBitrateRangeUnit->setEnabled( false );
    }
}

void OptionsDetailed::bitrateRangeToggled()
{
    if( cBitrateRange->isChecked() && cBitrateRange->isEnabled() ) {
        sMinBitrate->setEnabled( true );
        lBitrateRangeTo->setEnabled( true );
        sMaxBitrate->setEnabled( true );
        lBitrateRangeUnit->setEnabled( true );
    }
    else {
        sMinBitrate->setEnabled( false );
        lBitrateRangeTo->setEnabled( false );
        sMaxBitrate->setEnabled( false );
        lBitrateRangeUnit->setEnabled( false );
    }
}

void OptionsDetailed::resampleToggled() {
    if( cResample->isChecked() && cResample->isEnabled() ) {
        cSampleRate->setEnabled( true );
        lSampleRateUnit->setEnabled( true );
    }
    else {
        cSampleRate->setEnabled( false );
        lSampleRateUnit->setEnabled( false );
    }
}

void OptionsDetailed::channelsToggled() {
    if( cChannels->isChecked() && cChannels->isEnabled() ) {
        cNumChannels->setEnabled( true );
    }
    else {
        cNumChannels->setEnabled( false);
    }
}

void OptionsDetailed::setFormat( QString format )
{
    cFormat->setCurrentItem( formatIndex(format) );

    formatChanged();
}

void OptionsDetailed::setQualityMode( QString qualityMode )
{
    cQualityMode->setCurrentItem( qualityModeIndex(qualityMode) );
    qualityModeChanged();
}

void OptionsDetailed::setQuality( int quality )
{
    sQuality->setValue( quality );
}

void OptionsDetailed::setBitrateMode( QString bitrateMode )
{
    cBitrateMode->setCurrentItem( bitrateModeIndex(bitrateMode) );
    bitrateModeChanged();
}

void OptionsDetailed::setBitrateRange( bool enabled )
{
    cBitrateRange->setChecked( enabled );
}

void OptionsDetailed::setMinBitrate( int bitrate )
{
    sMinBitrate->setValue( bitrate );
}

void OptionsDetailed::setMaxBitrate( int bitrate )
{
    sMaxBitrate->setValue( bitrate );
}

void OptionsDetailed::setResample( bool enabled )
{
    cResample->setChecked( enabled );
}

void OptionsDetailed::setSampleRate( int sampleRate )
{
    char text[8];

    sprintf(text,"%i",sampleRate);

    cSampleRate->setCurrentText(text);
}

void OptionsDetailed::setSampleRateString( QString sampleRate )
{
    cSampleRate->setCurrentText(sampleRate);
}

void OptionsDetailed::setChannels( bool enabled )
{
    cChannels->setChecked( enabled );
}

void OptionsDetailed::setNumChannels( QString channels )
{
    cNumChannels->setCurrentItem( numChannelsIndex(channels) );
}

void OptionsDetailed::setReplayGain( bool enabled )
{
    cReplayGain->setChecked( enabled );
}


QString OptionsDetailed::getFormat()
{
    return cFormat->currentText();
}

QString OptionsDetailed::getQualityMode()
{
    return cQualityMode->currentText();
}

int OptionsDetailed::getQuality()
{
    return sQuality->value();
}

bool OptionsDetailed::getBitrateRange()
{
    return cBitrateRange->isChecked();
}

bool OptionsDetailed::getResample()
{
    return cResample->isChecked();
}

int OptionsDetailed::getSampleRate()
{
    QString text=cSampleRate->currentText();
    int value;

    sscanf(text,"%i",&value);

    return value;
}

bool OptionsDetailed::getChannels()
{
    return cChannels->isChecked();
}

QString OptionsDetailed::getNumChannels()
{
    return cNumChannels->currentText();
}

/*void OptionsDetailed::moreOptionsClicked()
{
    emit showMoreOptions();
}
*/
