

#ifndef _SHAREDDIR_H_
#define _SHAREDDIR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <kprocess.h>

class QComboBox;
class QLineEdit;
class KPushButton;
class KToolBarButton;

/**
 * @short Shared dir
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class SharedDir : public QWidget
{
    Q_OBJECT
public:
    enum Mode {
        Original, Shared, Metadata, Copy
    };

    /**
     * Default Constructor
     */
    SharedDir( QWidget *parent=0, const char *name=0 );

    int mode();
    QString dir();
    QString calcFilename();

    /**
     * Default Destructor
     */
    virtual ~SharedDir();

public slots:
    void modeChanged(int);
    void selectDir();
    void gotoDir();
    void conversionStarted();
    void conversionStoped();
    void modeInfo();
    void dirInfo();
    void savePaths();

private:
    QComboBox *cMode;
    KPushButton *pModeInfo;
    QLineEdit *lDir;
    KPushButton *pDirSelect;
    KPushButton *pDirGoto;
    KPushButton *pDirInfo;
    KToolBarButton *pClear;
    KProcess kfm;
    int lastMode;
    QString sharedDirPath;
    QString metadataPath;
    QString copyStructurePath;

};

#endif // _SHAREDDIR_H_
