

#ifndef _SOUNDKONVERTER_H_
#define _SOUNDKONVERTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "dcopinterface.h"

#include <qdatetime.h>

#include <kmainwindow.h>
#include <kio/jobclasses.h>
#include <kfileitem.h>

class Options;
class SharedDir;
class FileList;
class Convert;
class Protocol;
class ComboButton;
class FirstRunWizard;
class ReplayGainScanner;
class CueEditor;

class QTextEdit;
class QStringList;
class QString;
class QComboBox;
class QProgressBar;
class QLabel;
class QTabWidget;
class KPushButton;
class KAction;
class KToggleAction;
class KActionMenu;
class KDirLister;

/**
 * @short Application Main Window
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class soundKonverter : public KMainWindow, virtual public DCOPInterface
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    soundKonverter();

    /**
     * Default Destructor
     */
    virtual ~soundKonverter();

    void openFiles(const QStringList &files);
    void openReplayGainFiles(const QStringList &files);
    void increaseInstances();

signals:
    void addFiles(QStringList);
    void removeFirstFile();
    void conversionStarted();
    void conversionStoped();
    void decode();
    void encode();
    void kill();
    void sendOutput(QStringList);
    void updateFileListLook();
    void resetOptions();
    void readFileList();
    void saveFileList();
    void quitSoundKonverter();
    void addFilesToReplayGainScanner(QStringList);
    void setPriority(int);

private slots:
    void addClicked(int);
    void pasteFiles();
    void showFileDialogue();
    void showDirDialogue();
    void allFilesListed(const KFileItemList&);
    void scanStatus(int);
    //void scanCompleted();
    void showConfigDialogue();
    void priorityChanged();
    void startConversion();
    void stopConversion();
    void continueConversion();
    void killConversion();
    void showProtocol();
    void timeAdded(float);
    void timeRemoved(float);
    void timeConverted(float);
    void updateStatus();
    void conversionExited(int);
    void getOutput(QString);
    void fileListDropEvent(QDropEvent*);

    void showToolbar();
    void editToolbar();
    void newToolbarConfig();
    void showReplayGainScanner();
    void showCueEditor();
    void downloadPluginListFinished(KIO::Job*);
    void downloadBackendListFinished(KIO::Job*);

private:
    Options *options;
    SharedDir *sharedDir;
    FileList *fileList;
    Convert *convert;
    Protocol *protocol;
    FirstRunWizard *firstRunWizard;
    KDirLister *dirLister;

    QStringList cmd;
    float totalTime;
    float processedTime;
    bool bStoped;
    bool bKilled;
    QTime remainingTime;
    int instances;
    KIO::FileCopyJob *downloadPluginListJob;
    KIO::FileCopyJob *downloadBackendListJob;

    KPushButton *pShowMenu;
    KPushButton *pNewPlugins;
    KPushButton *pNewBackends;
    KPushButton *pNewLocalBackends;
    QTabWidget *tab;
    ComboButton *cAdd;
    QProgressBar *pScanStatus;
    KPushButton *pSettings;
    KPushButton *pHelp;
    QTextEdit *tCmd;
    KPushButton *pStart;
    KPushButton *pStop;
    KPushButton *pProtocol;
    QComboBox *cPriority;
    QProgressBar *pProgress;
    QLabel *lSpeed;
    QLabel *lTime;

    ReplayGainScanner *replayGainScanner;
    CueEditor *cueEditor;

    KAction *startAction;
    KAction *stopAction;
    KAction *continueAction;
    KAction *killAction;
    KActionMenu *stopActionMenu;
    KToggleAction *showToolBarAction;
    KToggleAction *veryHighPriorityAction;
    KToggleAction *highPriorityAction;
    KToggleAction *normalPriorityAction;
    KToggleAction *lowPriorityAction;
    KToggleAction *veryLowPriorityAction;
    KActionMenu *priorityActionMenu;

    void convertNextFile();
    void resetTags();
    void readTags();
    void writeTags();
    void scanForBackends();

protected:
    virtual bool queryClose();

};

#endif // _SOUNDKONVERTER_H_
