

#ifndef CONFIGGENERALPAGE_H
#define CONFIGGENERALPAGE_H

#include <configpagebase.h>

class Config;
class QCheckBox;
class KComboBox;
class KIntSpinBox;
class KLineEdit;
class KPushButton;

/**
 * @short The page for the general configuration
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigGeneralPage : public ConfigPageBase
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigGeneralPage( Config*, QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigGeneralPage();

private:
    KComboBox* cStartTab;
    KComboBox* cDefaultProfile;
    QStringList sDefaultProfile;
    KComboBox* cDefaultFormat;
    QStringList sDefaultFormat;
//     KLineEdit* lDir;
    //KPushButton* pDirInfo;
//     KPushButton* pDirSelect;
    KComboBox* cPriority;
    QStringList sPriority;
    QCheckBox* cUseVFATNames;
    KIntSpinBox* iNumFiles;
    KIntSpinBox* iUpdateDelay;
    QCheckBox* cAskForNewOptions;

    Config* config;

    int profileIndex( const QString& string );
    int formatIndex( const QString& string );

public slots:
    void resetDefaults();
    void saveSettings();

private slots:
//     void selectDir();
    void profileChanged();

};

#endif // CONFIGGENERALPAGE_H

