
#ifndef CONFIGPLUGINSPAGE_H
#define CONFIGPLUGINSPAGE_H

#include <configpagebase.h>

#include <kio/jobclasses.h>

class Config;
class KPushButton;
class KListBox;
class QCheckBox;

/**
 * @short The page for configuring the plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigPluginsPage : public ConfigPageBase
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigPluginsPage( Config*, QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigPluginsPage();

private:
    KListBox* lPlugins;
    KPushButton* pAddPlugin;
    KIO::FileCopyJob* getPluginJob;
    KPushButton* pRemovePlugin;
    KPushButton* pAboutPlugin;
    KListBox* lOnlinePlugins;
    KPushButton* pRefreshOnlinePlugins;
    KIO::FileCopyJob* refreshOnlinePluginsJob;
    KPushButton* pInstallOnlinePlugin;
    KIO::FileCopyJob* getOnlinePluginJob;
    KPushButton* pUpgradeOnlinePlugins;
    KPushButton* pAboutOnlinePlugin;
    KIO::FileCopyJob* aboutOnlinePluginJob;
    QCheckBox* cCheckOnlinePlugins;

    QString getPluginFilePathName;

    Config* config;

public slots:
    void resetDefaults();
    void saveSettings();

// signals:
//     void configChanged();
//     void recalcEnDecoderPage();
//     void reloadEnDecoderPage();
//     void rescanForBackends();

private slots:
    void pluginsSelectionChanged( int );
    void refreshPlugins();
    void getPlugin();
    void getPluginFinished( KIO::Job* );
    void removePlugin();
    void aboutPlugin();

    void onlinePluginsSelectionChanged( int );
    void refreshOnlinePlugins();
    void refreshOnlinePluginsFinished( KIO::Job* );
    void getOnlinePlugin();
    void getOnlinePluginFinished( KIO::Job* );
    void aboutOnlinePlugin();
    void aboutOnlinePluginFinished( KIO::Job* );

};

#endif // CONFIGPLUGINSPAGE_H

