
#include "options.h"
#include "optionssimple.h"
#include "optionsdetailed.h"
#include "config.h"

#include <qlayout.h>
#include <qtooltip.h>
#include <qfile.h>
#include <qcolor.h>

#include <klocale.h>
#include <ktabwidget.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <kio/job.h>
#include <kstandarddirs.h>

// FIXME prevent converting wav files to wav

Options::Options( Config* _config, const QString &text, QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    config = _config;
    connect( config, SIGNAL(configChanged()),
               this, SLOT(configChanged())
             );

    QGridLayout *gridLayout = new QGridLayout( this, 1, 1 );

    tab = new KTabWidget( this, "tab" );

    optionsDetailed = new OptionsDetailed( config, this, "optionsDetailed" );
    optionsSimple = new OptionsSimple( config, optionsDetailed, text, this, "optionsSimple" );

    tab->addTab( optionsSimple, i18n("Simple") );
    connect( optionsSimple, SIGNAL(optionsChanged()),
             this, SLOT(somethingChanged())
           );

    tab->addTab( optionsDetailed, i18n("Detailed") );
    connect( optionsDetailed, SIGNAL(optionsChanged()),
             this, SLOT(somethingChanged())
           );

//     connect( optionsSimple, SIGNAL(setFormat(const QString&)),
//              optionsDetailed, SLOT(setFormat(const QString&))
//            );
//     connect( optionsSimple, SIGNAL(setQualityMode(const QString&)),
//              optionsDetailed, SLOT(setQualityMode(const QString&))
//            );
//     connect( optionsSimple, SIGNAL(setQuality(int)),
//              optionsDetailed, SLOT(setQuality(int))
//            );
//     connect( optionsSimple, SIGNAL(setBitrateMode(const QString&)),
//              optionsDetailed, SLOT(setBitrateMode(const QString&))
//            );
//     connect( optionsSimple, SIGNAL(setBitrateRangeEnabled(bool)),
//              optionsDetailed, SLOT(setBitrateRangeEnabled(bool))
//            );
//     connect( optionsSimple, SIGNAL(setMinBitrate(int)),
//              optionsDetailed, SLOT(setMinBitrate(int))
//            );
//     connect( optionsSimple, SIGNAL(setMaxBitrate(int)),
//              optionsDetailed, SLOT(setMaxBitrate(int))
//            );
//     connect( optionsSimple, SIGNAL(setSamplingrateEnabled(bool)),
//              optionsDetailed, SLOT(setSamplingrateEnabled(bool))
//            );
//     connect( optionsSimple, SIGNAL(setSamplingrate(int)),
//              optionsDetailed, SLOT(setSamplingrate(int))
//            );
//     connect( optionsSimple, SIGNAL(setSamplingrate(const QString&)),
//              optionsDetailed, SLOT(setSamplingrate(const QString&))
//            );
//     connect( optionsSimple, SIGNAL(setChannelsEnabled(bool)),
//              optionsDetailed, SLOT(setChannelsEnabled(bool))
//            );
//     connect( optionsSimple, SIGNAL(setChannels(const QString&)),
//              optionsDetailed, SLOT(setChannels(const QString&))
//            );
//     connect( optionsSimple, SIGNAL(setReplayGainEnabled(bool)),
//              optionsDetailed, SLOT(setReplayGainEnabled(bool))
//            );
//     connect( optionsSimple, SIGNAL(setOutputDirectoryMode(OutputDirectory::Mode)),
//              optionsDetailed, SLOT(setOutputDirectoryMode(OutputDirectory::Mode))
//            );
//     connect( optionsSimple, SIGNAL(setOutputDirectoryPath(const QString&)),
//              optionsDetailed, SLOT(setOutputDirectoryPath(const QString&))
//            );
//     connect( optionsSimple, SIGNAL(setOptions(const ConversionOptions&)),
//              optionsDetailed, SLOT(setCurrentOptions(const ConversionOptions&))
//            );
//     connect( optionsSimple, SIGNAL(setUserOptions(const QString&)),
//              optionsDetailed, SLOT(setUserOptions(const QString&))
//            );

    if( config->data.general.startTab == 0 ) tab->setCurrentPage( config->data.general.lastTab );
    else tab->setCurrentPage( config->data.general.startTab - 1 );
    gridLayout->addWidget( tab, 0, 0 );
    connect( tab, SIGNAL( currentChanged(QWidget*) ),
              this, SLOT( tabChanged(QWidget*) )
             );

    // draw the toggle button
    QVBoxLayout *optionsTopBox = new QVBoxLayout( -1, "optionsTopBox" );
    gridLayout->addLayout( optionsTopBox, 0, 0 );

    QHBoxLayout *optionsBox = new QHBoxLayout( 6, "optionsBox" );
    optionsTopBox->addLayout( optionsBox );
    optionsTopBox->addStretch();

    optionsBox->addStretch();

//     pPluginsNotify = new KPushButton( "", this, "pPluginsNotify");
//     pPluginsNotify->setPixmap( KGlobal::iconLoader()->loadIcon("connect_creating",KIcon::Toolbar) );
//     QToolTip::add( pPluginsNotify, i18n("There are new plugin updates available.\nClick on this button in order to open the configuration dialog.") );
//     pPluginsNotify->hide();
//     pPluginsNotify->setPaletteBackgroundColor( QColor(255,220,247) );
//     optionsBox->addWidget( pPluginsNotify );
//     connect( pPluginsNotify, SIGNAL(clicked()),
//                this, SLOT(showConfigDialogPlugins())
//              );

    pBackendsNotify = new KPushButton( "", this, "pBackendsNotify");
    pBackendsNotify->setPixmap( KGlobal::iconLoader()->loadIcon("kcmsystem",KIcon::Toolbar) );
    QToolTip::add( pBackendsNotify, i18n("soundKonverter either found new backends or misses some.\nClick on this button in order to open the configuration dialog.") );
    pBackendsNotify->setShown( config->backendsChanged );
    config->backendsChanged = false;
    pBackendsNotify->setPaletteBackgroundColor( QColor(255,220,247) );
    optionsBox->addWidget( pBackendsNotify );
    connect( pBackendsNotify, SIGNAL(clicked()),
               this, SLOT(showConfigDialogBackends())
             );

    pAdvancedOptionsToggle = new KPushButton( i18n("Advanced Options"), this, "pAdvancedOptionsToggle");
    pAdvancedOptionsToggle->setToggleButton( true );
    pAdvancedOptionsToggle->hide();
    optionsBox->addWidget( pAdvancedOptionsToggle );
    connect( pAdvancedOptionsToggle, SIGNAL(clicked()),
               optionsDetailed, SLOT(toggleAdvancedOptions())
             );
/* NOTE kaligames.de is down
    if( config->data.plugins.checkForUpdates ) {
        config->onlinePluginsChanged = false;
        getPluginListJob = KIO::file_copy("http://kaligames.de/downloads/soundkonverter/plugins/download.php?version=" + QString::number(config->data.app.configVersion),
            locateLocal("data","soundkonverter/pluginlist_new.txt"), -1, true, false, false );
        connect( getPluginListJob, SIGNAL(result(KIO::Job*)),
                   this, SLOT(getPluginListFinished(KIO::Job*))
                 );
    }
*/
    if( config->data.general.defaultProfile == i18n("Last used") || config->getAllProfiles().findIndex(config->data.general.defaultProfile) != -1 ) {
        setCurrentOptions( config->getProfile(config->data.general.defaultProfile) );
    }
    else {
        setProfile( config->data.general.defaultProfile );
        setFormat( config->data.general.defaultFormat );
    }
}

Options::~Options()
{}

// void Options::getPluginListFinished( KIO::Job* job )
// {
//     if( job->error() == 0 ) {
//         QFile file( locateLocal("data","soundkonverter/pluginlist.txt") );
//         QFile newFile( locateLocal("data","soundkonverter/pluginlist_new.txt") );
// 
//         if( !file.exists() ) { // TODO check against the installed plugins
//             pPluginsNotify->show();
//             KIO::file_move( locateLocal("data","soundkonverter/pluginlist_new.txt"), locateLocal("data","soundkonverter/pluginlist.txt"), -1, true, false, false );
//             config->onlinePluginsChanged = true;
//             return;
//         }
// 
//         if( file.open(IO_ReadOnly) && newFile.open(IO_ReadOnly) ) {
//             QTextStream stream( &file );
//             QTextStream newStream( &newFile );
//             while( !stream.atEnd() && !newStream.atEnd() ) {
//                 if( stream.readLine() != newStream.readLine() ) {
//                     file.close();
//                     newFile.close();
//                     pPluginsNotify->show();
//                     KIO::file_move( locateLocal("data","soundkonverter/pluginlist_new.txt"), locateLocal("data","soundkonverter/pluginlist.txt"), -1, true, false, false );
//                     config->onlinePluginsChanged = true;
//                     return;
//                 }
//             }
//             if( stream.atEnd() != newStream.atEnd() ) {
//                 file.close();
//                 newFile.close();
//                 pPluginsNotify->show();
//                 KIO::file_move( locateLocal("data","soundkonverter/pluginlist_new.txt"), locateLocal("data","soundkonverter/pluginlist.txt"), -1, true, false, false );
//                 config->onlinePluginsChanged = true;
//                 return;
//             }
//             file.close();
//             newFile.close();
//         }
//         newFile.remove();
//     }
// }

// void Options::showConfigDialogPlugins()
// {
//     pPluginsNotify->hide();
//     emit showConfigPluginsPage();
// }

void Options::showConfigDialogBackends()
{
    pBackendsNotify->hide();
    emit showConfigEnvironmentPage();
}

ConversionOptions Options::getCurrentOptions()
{
    return optionsDetailed->getCurrentOptions();
}

void Options::setCurrentOptions( const ConversionOptions& options )
{
    optionsDetailed->setCurrentOptions( options );
    /*if( tab->page(tab->currentPageIndex()) == optionsSimple ) {
        optionsSimple->refill();
    }*/
    optionsSimple->refill();
}

void Options::tabChanged( QWidget* widget )
{
    if( widget == optionsSimple ) {
        pAdvancedOptionsToggle->hide();
        optionsSimple->refill();
    }
    else {
        pAdvancedOptionsToggle->show();
    }
    config->data.general.lastTab = tab->currentPageIndex();
}

void Options::setProfile( const QString& profile )
{
    optionsSimple->setCurrentProfile( profile );
}

void Options::setFormat( const QString& format )
{
    optionsSimple->setCurrentFormat( format );
}

void Options::setOutputDirectory( const QString& directory )
{
    optionsSimple->setCurrentOutputDirectory( directory );
}

void Options::somethingChanged()
{
    emit optionsChanged();
}

// TODO right this way? - seems to work
void Options::configChanged()
{
    optionsDetailed->refill();
    /*if( tab->page(tab->currentPageIndex()) == optionsSimple ) {
        optionsSimple->refill();
    }*/
    optionsSimple->refill();
}

