

#ifndef CONVERTPLUGINLOADER_H
#define CONVERTPLUGINLOADER_H

#include "pluginloaderbase.h"


/**
 * @short The complete data, how to use the backend
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConvertPlugin
{
public:
    /**
     * Constructor
     */
    ConvertPlugin();

    /**
     * Destructor
     */
    virtual ~ConvertPlugin();

    QString filePathName; // the file name of th plugin (needed to detect write permissions)

    struct Info
    {
        int version;    // the version of our plugin (v0.2.1 = 201, v11.3 = 110300)
        QString name;   // the name of our plugin
        QString author; // the author of the plugin
        QString about;  // a short information aboue the plugin
    } info;

    struct Enc
    {
        bool enabled;
        int rank;
        QString bin;
        QString param;
        QString silent_param;
        QStringList mime_types;
        QString in_out_files;
        QString overwrite;

        struct Strength {
            bool enabled;
            QString param;
            float range_min;
            float range_max;
            float step;
            QChar separator;
            QStringList profiles;
            float default_value;
        } strength;

        struct Lossy {
            bool enabled;

            struct Quality {
                bool enabled;
                QString param;
                float range_min;
                float range_max;
                float step;
                QChar separator;
                QString help;
                QString output;
                QStringList profiles; // NOTE when using profiles, step must be 1 and range_min 0
            } quality;

            struct Bitrate {
                struct Abr
                {
                    bool enabled;
                    QString param;
                    QString output;

                    struct BitrateRange {
                        bool enabled;
                        QString param_min;
                        QString param_max;
                    } bitrate_range;

                } abr;

                struct Cbr {
                    bool enabled;
                    QString param;
                    QString output;
                } cbr;

            } bitrate;

            struct Samplingrate {
                bool enabled;
                QString param;
                PluginLoaderBase::Unit unit;
            } samplingrate;

            struct Channels {
                bool stereo_enabled;
                QString stereo_param;
                bool joint_stereo_enabled;
                QString joint_stereo_param;
                bool forced_joint_stereo_enabled;
                QString forced_joint_stereo_param;
                bool dual_channels_enabled;
                QString dual_channels_param;
                bool mono_enabled;
                QString mono_param;
            } channels;
        } lossy;

        struct Lossless {
            bool enabled;
            QString param;
            QString output;
        } lossless;

        struct Hybrid {
            bool enabled;
            QString param;
            QString output;
            QString correction_file_mime_type;
        } hybrid;

        struct ReplayGain {
            bool enabled;
            QString use;
            QString avoid;
            int rank;
        } replaygain;

        struct Tag {
            bool enabled;
            QString param;
            QString artist;
            QString composer;
            QString album;
            QString disc;
            QString title;
            QString genre;
            QString comment;
            QString track;
            QString year;
        } tag;
    } enc;

    struct Dec {
        bool enabled;
        int rank;
        QString bin;
        QString param;
        QString silent_param;
        QStringList mime_types;
        QString output;
        QString in_out_files;
        QString overwrite;
    } dec;
};

/**
 * @short The plugin loader for the converter plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConvertPluginLoader : public PluginLoaderBase
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    ConvertPluginLoader();

    /**
     * Destructor
     */
    virtual ~ConvertPluginLoader();

    /** is this file a converter plugin and loadable? */
    int verifyFile( QString );
    /** load a given file */
    ConvertPlugin* loadFile( QString );
};

#endif // CONVERTPLUGINLOADER_H
