
#include "progressindicator.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qtooltip.h>

#include <klocale.h>
#include <ksystemtray.h>
//#include <kiconloader.h>
//#include <kmessagebox.h>
// #include <kdebug.h>


ProgressIndicator::ProgressIndicator( KSystemTray* _systemTray, QWidget* parent, const char* name )
    : QWidget( parent, name )
{
    systemTray = _systemTray;

    time = processedTime = 0;

    QGridLayout *grid = new QGridLayout( this, 1, 1, 0, 6, "grid" );

    QHBoxLayout *box = new QHBoxLayout( );
    grid->addLayout( box, 0, 0 );

    pBar = new QProgressBar( this, "pBar" );
    box->addWidget( pBar );

    QGridLayout *statusChildGrid = new QGridLayout( box, 2, 2, 6, "statusChildGrid" );

    QLabel *lSpeedText = new QLabel( i18n("Speed")+":", this, "lSpeedText" );
    statusChildGrid->addWidget( lSpeedText, 0, 0, Qt::AlignVCenter );

    lSpeed = new QLabel( "0.0x", this, "lSpeed" );
    lSpeed->setFont( QFont( "Courier" ) );
    statusChildGrid->addWidget( lSpeed, 0, 1, Qt::AlignVCenter | Qt::AlignRight );
    speedTime.setHMS( 24, 0, 0 );

    QLabel *lTimeText = new QLabel( i18n("Time remaining")+":", this, "lTimeText" );
    statusChildGrid->addWidget( lTimeText, 1, 0, Qt::AlignVCenter );

    lTime = new QLabel( "00:00", this, "lTime" );
    lTime->setFont( QFont( "Courier" ) );
    statusChildGrid->addWidget( lTime, 1, 1, Qt::AlignVCenter | Qt::AlignRight );
    elapsedTime.setHMS( 24, 0, 0 );

    QToolTip::add( systemTray, i18n("Waiting") );
}

ProgressIndicator::~ProgressIndicator()
{}

void ProgressIndicator::increaseTime( float t )
{
    time += t;
//     kdDebug() << "increaseTime: " << time << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::decreaseTime( float t )
{
    time -= t;
//     kdDebug() << "decreaseTime: " << time << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::countTime( float t )
{
    processedTime += t;
//     kdDebug() << "countTime: " << processedTime << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::uncountTime( float t )
{
    processedTime -= t;
//     kdDebug() << "uncountTime: " << processedTime << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::setTime( float t )
{
    time = t;
//     kdDebug() << "setTime: " << time << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::finished( float t )
{
    time = t;
//     kdDebug() << "finished: " << time << " (" << t  << ")" <<  endl;
    processedTime = 0;
    pBar->setProgress( 100, 100 );
    elapsedTime.setHMS( 24, 0, 0 );
    lTime->setText( "00:00" );
    speedTime.setHMS( 24, 0, 0 );
    lSpeed->setText( "0.0x" );
    QToolTip::add( systemTray, i18n("Finished") );
    emit setTitle( i18n("Finished") );
}

void ProgressIndicator::update( float t )
{
//     kdDebug() << "update: " << (processedTime + t) << " / " << time  << endl;
    pBar->setProgress( int(processedTime + t), int(time) );
    float fPercent;
//     if( pBar->totalSteps() > 0 ) fPercent = pBar->progress() * 100 / pBar->totalSteps();
    if( pBar->totalSteps() > 0 ) fPercent = (processedTime+t)*100.0f / time;
    else fPercent = 0.1f;

    if( !elapsedTime.isValid() ) elapsedTime.start();
    if( !speedTime.isValid() ) speedTime.start();
    if( speedTime.elapsed() > 1000 ) {
        if( elapsedTime.elapsed() > 10000 ) {
//             int tim = (int)( 1 + ((100/fPercent)-1) * (elapsedTime.elapsed()/1000) );
            int tim = (int)(( 1.0f + ((100.0f/fPercent)-1.0f) * (elapsedTime.elapsed()/1000.0f) ));
            //float fPercent = pBar->progress() / pBar->totalSteps();
            //int tim = (int)( 1 + (elapsedTime.elapsed()/fPercent - elapsedTime.elapsed()) / 1000 );
            if( tim >= 0 && tim < 1000000 ) {
                int sec = tim % 60;
                int min = ( tim / 60 ) % 60;
                int hou = tim / 3600;
                QString timeLeft;
                if( hou > 0 )
                    timeLeft.sprintf( "%d:%02d:%02d", hou, min, sec );
                else
                    timeLeft.sprintf( "%02d:%02d", min, sec );
                lTime->setText( timeLeft );
            }
        }

        int tim = speedTime.restart() / 1000;
        float speed = ( processedTime + t - speedProcessedTime ) / tim;
        speedProcessedTime = processedTime + t;
        if( speed >= 0.0f && speed < 100000.0f ) {
            QString actSpeed;
            actSpeed.sprintf( "%.1fx", speed );
            lSpeed->setText( actSpeed );
        }
    }

    QString percent;
    percent.sprintf( "%i%%", (int)fPercent );
    emit setTitle( percent );
    QToolTip::add( systemTray, percent );
}

