/*
 * Copyright 1997 Chris Bagwell And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained.
 * Chris Bagwell And Sundry Contributors are not
 * responsible for the consequences of using this software.
 *
 * MS Wave driver
 *
 */

#include "st_i.h"

#define MMWAVE_PLAYER

#if	defined(MMWAVE_PLAYER)

#include <windows.h>
#include <mmsystem.h>

typedef struct mmwavestuff
{
    HWAVEOUT dev;
    WAVEHDR *wavehdr[2];
    int max_buffers;
    int next_empty;
    int current_buffer;
    int full;
} *mmwave_t;
    
static void CALLBACK mmwave_callback(HWAVEOUT devt, UINT msg, DWORD instance,
	                             DWORD param1, DWORD param2)
{
    if (msg == WOM_DONE)
    {
        mmwave_t mmwave = (mmwave_t)instance;

        printf("Entered callback current = %d next == %d max = %d full = %d\n",mmwave->current_buffer, mmwave->next_empty, mmwave->max_buffers, mmwave->full);

        /* The current buffer has been played so advance pointer to next
         * location to play.
         */
        mmwave->current_buffer++;
        if (mmwave->current_buffer >= mmwave->max_buffers)
    	    mmwave->current_buffer = 0;

        /* If next buffer to play contains no data then do not write 
         * anything.
         */
        if (!mmwave->full && mmwave->current_buffer == mmwave->next_empty)
	    return;

        waveOutWrite(mmwave->dev, mmwave->wavehdr[mmwave->current_buffer],
		     sizeof(WAVEHDR));

        mmwave->full = 0;
    }

}

int st_mmwavestartwrite(ft_t ft)
{
    mmwave_t mmwave = (mmwave_t)ft->priv;
    WAVEFORMATEX wf;
    MMRESULT rc;

    printf("Starting MMWave player\n");
    if (waveOutGetNumDevs() <= 0)
    {
	st_fail_errno(ft,ST_EOF,"Unable able to open WAVE device");
	return(ST_EOF);
    }

    /* FIXME: Print error messages if user specifies sizes */
    wf.wBitsPerSample = 32;
    wf.nBlockAlign = 4 * ft->info.channels;
    wf.wFormatTag = WAVE_FORMAT_PCM;
    wf.nChannels = ft->info.channels;
    wf.nSamplesPerSec = ft->info.rate;
    wf.nBlockAlign *= ft->info.channels;
    wf.nAvgBytesPerSec = 4 * ft->info.rate;
    wf.cbSize = sizeof(WAVEFORMATEX);

    rc = waveOutOpen(&mmwave->dev, WAVE_MAPPER, &wf, 
	             (DWORD)mmwave_callback, (DWORD)mmwave, 
		     CALLBACK_FUNCTION);

    if (rc != S_OK)
    {
        st_fail_errno(ft,ST_EOF, "Unable to open Wave device\n");
	return(ST_EOF);
    }

    printf("Opened device\n");

    printf("malloc 1\n");
    mmwave->wavehdr[0] = (WAVEHDR *)malloc(ST_BUFSIZ*4);
    printf("malloc 2\n");
    mmwave->wavehdr[1] = (WAVEHDR *)malloc(ST_BUFSIZ*4);
    printf("malloc 3\n");
    mmwave->wavehdr[0]->lpData = (char *)malloc(ST_BUFSIZ*4);
    printf("malloc 4\n");
    mmwave->wavehdr[1]->lpData = (char *)malloc(ST_BUFSIZ*4);

    printf("null test\n");
    if (!mmwave->wavehdr[0] || !mmwave->wavehdr[1] || 
        !mmwave->wavehdr[0]->lpData || !mmwave->wavehdr[1]->lpData)
    {
	/* FIXME: Free memory */
	st_fail_errno(ft, ST_ENOMEM, "Could not allocate memory");
	return(ST_EOF);
    }

    printf("Preparing header 0\n");
    mmwave->wavehdr[0]->dwBufferLength = ST_BUFSIZ;
    if (waveOutPrepareHeader(mmwave->dev, mmwave->wavehdr[0], sizeof(WAVEHDR)))
    {
	/* FIXME: Free memory */
	st_fail_errno(ft, ST_EOF, "Could not initialize Wave Header");
	return(ST_EOF);
    }

    printf("Preparing header 1\n");
    mmwave->wavehdr[1]->dwBufferLength = ST_BUFSIZ;
    if (waveOutPrepareHeader(mmwave->dev, mmwave->wavehdr[1], sizeof(WAVEHDR)))
    {
	/* FIXME: Free memory */
	st_fail_errno(ft, ST_EOF, "Could not initialize Wave Header");
	return(ST_EOF);
    }

    printf("Setup up player, starting to play\n");

    mmwave->max_buffers = 2;
    mmwave->next_empty = 0;
    mmwave->current_buffer = 0;
    mmwave->full = 0;
    return(ST_SUCCESS);
}

st_ssize_t st_mmwavewrite(ft_t ft, st_sample_t *buf, st_ssize_t len)
{
    mmwave_t mmwave = (mmwave_t)ft->priv;

    /* FIXME: Need to check if len same size of ST_BUFSIZ */

    if (mmwave->full)
    {
	/* Block until there is a free buffer */
	printf("Oops, need to flush\n");
        while(mmwave->full)
            ;;
    }

    printf("copying to buffer next = %d current = %d full = %d\n",mmwave->next_empty, mmwave->current_buffer, mmwave->full);

    memcpy(mmwave->wavehdr[mmwave->next_empty]->lpData,
	   buf, len*4);

    mmwave->wavehdr[mmwave->next_empty]->dwBufferLength = len;

    /* Write this out if it appears a callback wont do it */
    if (mmwave->current_buffer == mmwave->next_empty)
    {
	printf("Forcing write!\n");

	waveOutWrite(mmwave->dev, mmwave->wavehdr[mmwave->next_empty],
		sizeof(WAVEHDR));
    }

    mmwave->next_empty++;
    if (mmwave->next_empty >= mmwave->max_buffers)
	mmwave->next_empty = 0;

    if (mmwave->next_empty == mmwave->current_buffer)
        mmwave->full = 1;

    return(len);
}

int st_mmwavestopwrite(ft_t ft)
{
    mmwave_t mmwave = (mmwave_t)ft->priv;

    sleep(5);

    waveOutReset(mmwave->dev);

    waveOutUnprepareHeader(mmwave->dev, mmwave->wavehdr[1], sizeof(WAVEHDR));
    free(mmwave->wavehdr[1]->lpData);
    waveOutUnprepareHeader(mmwave->dev, mmwave->wavehdr[0], sizeof(WAVEHDR));
    free(mmwave->wavehdr[0]->lpData);

    free(mmwave->wavehdr[1]);
    free(mmwave->wavehdr[0]);

    waveOutClose(mmwave->dev);
    return(ST_SUCCESS);
}

#endif
