/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * glext.c : functions added to gl
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

#include <math.h>

#include "p3_base.h"
#include "image.h"
#include "material.h"

extern int screen_w;
extern int screen_h;


void glPerspective (GLdouble fovy, GLdouble aspect, GLdouble znear, GLdouble zfar) {
  /* this code is adapted from Mesa :) */
  GLdouble y;
  GLdouble x;
  /* y = znear * tan (fovy * 0.5 * pi / 180.0) */
  y = znear * tan (fovy * 0.008727);
  x = y * aspect;
  glFrustum (-x, x, -y, y, znear, zfar);
}

GLubyte* P3_image_scale_down_2 (int nb_color, int w, int h, GLubyte* pixels) {
  int i; int j; int m; 
  int x; 
  int y; 
  int new_w;
  int new_h;
  GLubyte* new_pixels;
  if (w == 1 || h == 1) {
    if (w == 1) { new_w = 1; } else { new_w = (int) (w * 0.5); }
    if (h == 1) { new_h = 1; } else { new_h = (int) (h * 0.5); }
    new_pixels = (GLubyte*) malloc (new_h * new_w * nb_color * sizeof(GLubyte));
    for (j = 0; j < new_h; j++) {
      for (i = 0; i < new_w; i++) {
        for (m = 0; m < nb_color; m++) {
          *(new_pixels + (i + new_w * j) * nb_color + m) = *(pixels + (i + w * j) * nb_color * 2 + m);
        }
      }
    }
  } else {
    new_w = (int) (w * 0.5);
    new_h = (int) (h * 0.5);
    new_pixels = (GLubyte*) malloc(new_h * new_w * nb_color * sizeof(GLubyte));
    for (j = 0; j < new_h; j++) {
      y = (int) (j * 2);
      for (i = 0; i < new_w; i++) {
        x = (int) (i * 2);
        for (m = 0; m < nb_color; m++) {
          *(new_pixels + (i + new_w * j) * nb_color + m) = (GLubyte) (
                ((float) *(pixels + (x     + w * y)       * nb_color + m)
                       + *(pixels + (x + 1 + w * y)       * nb_color + m)
                       + *(pixels + (x     + w * (y + 1)) * nb_color + m)
                       + *(pixels + (x + 1 + w * (y + 1)) * nb_color + m)) / 4.0);
        }
      }
    }
  }
  return new_pixels;
}

void P3_build2Dmipmaps (P3_material* t) {
  /* this code is adapted from Mesa :) */
  GLint w = t->image->width;  /* must be a power of 2 */
  GLint h = t->image->height; /* must be a power of 2 */
  GLubyte* image; 
  GLubyte* newimage;
  GLint level = 0; 
  int img_type;
  int img_int_format;
  image = t->image->pixels;
  img_type = P3_image_get_type (t->image);
  img_int_format = P3_image_get_internal_format (t->image);
  while (1) {
    glTexImage2D (GL_TEXTURE_2D, level, img_int_format, w, h, 0, img_type, GL_UNSIGNED_BYTE, image);
    if (w == 1 && h == 1) { break; }
    newimage = P3_image_scale_down_2 (t->image->nb_color, w, h, image);
    if (image != t->image->pixels) { free (image); }
    image = newimage;
    if (w != 1) { w = w >> 1; }
    if (h != 1) { h = h >> 1; }
    level++;
  }
  if (image != t->image->pixels) { free (image); }
}

void glPrintError (void) {
  GLenum error;
  error = glGetError ();
  if (error != GL_NO_ERROR) {
    switch (error) {
    case GL_INVALID_ENUM:
      P3_error ("GL_INVALID_ENUM");
      break;
    case GL_INVALID_VALUE:
      P3_error ("GL_INVALID_VALUE");
      break;
    case GL_INVALID_OPERATION:
      P3_error ("GL_INVALID_OPERATION");
      break;
    case GL_STACK_OVERFLOW:
      P3_error ("GL_STACK_OVERFLOW");
      break;
    case GL_STACK_UNDERFLOW:
      P3_error ("GL_STACK_UNDERFLOW");
      break;
    case GL_OUT_OF_MEMORY:
      P3_error ("GL_OUT_OF_MEMORY");
      break;
    }
  }
}

void P3_screenshot (char* filename) {
  GLubyte* pixels;
  FILE* file;
  pixels = (GLubyte*) malloc (3 * screen_w * screen_h * sizeof (GLubyte));
  glReadBuffer (GL_FRONT);
  glReadPixels (0, 0, screen_w, screen_h, GL_RGB, GL_UNSIGNED_BYTE, pixels);
  file = fopen (filename, "wb");
  if (file == NULL) { 
    P3_error ("can't open file %s", filename); 
    return;
  }
  P3_save_RGB_TGA (pixels, screen_w, screen_h, file);
  free (pixels);
  fclose (file);
}

