/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * math3d.h : math3d functions header
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

#define P3_to_radians(angle) ((angle) * P3_pi_180)
#define P3_to_degrees(angle) ((angle) * P3_pi_180_inv)

#define  P3_rnd ((GLfloat) (((double) rand ()) / ((double) RAND_MAX)))
//GLfloat  P3_float_from_double           (double d);
//GLfloat  P3_max_in_range                (GLfloat*, int);

void     P3_equation_2_2                (GLfloat* result, GLfloat a1, GLfloat b1, GLfloat c1, GLfloat a2, GLfloat b2, GLfloat c2);
int      P3_float_array_compare         (GLfloat* values, GLfloat* references, int nb);

int      P3_exp_of_2                    (int);
#define  P3_2_pow_n(a) (1 << (a))

int      P3_cone_from_sphere_and_origin (GLfloat* cone, GLfloat* sphere, GLfloat* point,  GLfloat length);
void     P3_cone_from_sphere_and_vector (GLfloat* cone, GLfloat* sphere, GLfloat* vector, GLfloat length);
int      P3_sphere_is_in_cone           (GLfloat* sphere, GLfloat* cone);

int      P3_point_is_in_sphere          (GLfloat[4], GLfloat[3]);
GLfloat  P3_sphere_distance_sphere      (GLfloat[4], GLfloat[4]);
GLfloat  P3_sphere_distance_point       (GLfloat[4], GLfloat[3]);
void     P3_sphere_instance_into        (GLfloat[4], P3_coordsys* old, P3_coordsys* new);
void     P3_sphere_from_points          (GLfloat[4], GLfloat*, int);
void     P3_sphere_from_3_points        (GLfloat[4], GLfloat*, GLfloat*, GLfloat*);
void     P3_sphere_from_spheres         (GLfloat[4], GLfloat*, int);
void     P3_sphere_from_2_spheres       (GLfloat result[4], GLfloat[4], GLfloat[4]);

void     P3_face_normal                 (GLfloat result[3], GLfloat[3], GLfloat[3], GLfloat[3]);
void     P3_face_plane                  (GLfloat result[4], GLfloat[3], GLfloat[3], GLfloat[3]);

GLfloat  P3_point_square_distance_to    (GLfloat[3], GLfloat[3]);
GLfloat  P3_point_distance_to           (GLfloat[3], GLfloat[3]);
GLfloat  P3_point_distance_plane        (GLfloat[3], GLfloat[4]);
void     P3_point_rotate_lateral        (GLfloat[3], GLfloat);
void     P3_point_rotate_vertical       (GLfloat[3], GLfloat);
void     P3_point_rotate_incline        (GLfloat[3], GLfloat);
void     P3_point_rotate_axe            (GLfloat[3], GLfloat, GLfloat, GLfloat, GLfloat);
void     P3_point_rotate                (GLfloat[3], GLfloat, GLfloat[3], GLfloat[3]);

void     P3_vector_normalize            (GLfloat[3]);
void     P3_vector_set_length           (GLfloat[3], GLfloat);
void     P3_vector_cross_product        (GLfloat[3], GLfloat[3], GLfloat[3]);
GLfloat  P3_vector_length               (GLfloat[3]);
GLfloat  P3_vector_square_length        (GLfloat[3]);
GLfloat  P3_vector_dot_product          (GLfloat[3], GLfloat[3]);
GLfloat  P3_vector_angle                (GLfloat[3], GLfloat[3]);
void     P3_vector_from_points          (GLfloat[3], GLfloat[3], GLfloat[3]);

//int      P3_quaternion_equal            (GLfloat[4], GLfloat[4]);
void     P3_quaternion_normalize        (GLfloat[4]);
void     P3_matrix_from_quaternion      (GLfloat[19], GLfloat[4]);
void     P3_quaternion_from_matrix      (GLfloat[4], GLfloat[16]);
void     P3_quaternion_rotation         (GLfloat[4], GLfloat[4], GLfloat);
void     P3_multiply_quaternion         (GLfloat[4], GLfloat[4], GLfloat[4]);
void     P3_quaternion_slerp            (GLfloat[4], GLfloat[4] ,GLfloat[4], GLfloat, GLfloat);
void     P3_quaternion_copy             (GLfloat[4], GLfloat[4]);

#define  P3_matrix_copy(dest, src) memcpy(dest, src, 19 * sizeof (GLfloat))
//void     P3_matrix_copy                 (GLfloat[19], GLfloat[19]);
void     P3_matrix_invert               (GLfloat[19], GLfloat[19]);
void     P3_multiply_matrix             (GLfloat[19], GLfloat[19], GLfloat[19]);
void     P3_point_by_matrix             (GLfloat[3], GLfloat[19]);
void     P3_point_by_matrix_copy        (GLfloat result[3], GLfloat[3], GLfloat[19]);
void     P3_point4_by_matrix            (GLfloat[4], GLfloat[19]);
void     P3_vector_by_matrix            (GLfloat[3], GLfloat[19]);
void     P3_vector_by_matrix_copy       (GLfloat result[3], GLfloat[3], GLfloat[19]);
GLfloat  P3_length_by_matrix            (GLfloat, GLfloat[19]);

//int      P3_matrix_equal                (GLfloat*, GLfloat*);
void     P3_matrix_set_identity         (GLfloat[19]);
void     P3_matrix_scale                (GLfloat[19], GLfloat, GLfloat, GLfloat);
void     P3_matrix_turn_lateral         (GLfloat[19], GLfloat);
void     P3_matrix_turn_vertical        (GLfloat[19], GLfloat);
void     P3_matrix_turn_incline         (GLfloat[19], GLfloat);
void     P3_matrix_turn_axe             (GLfloat[19], GLfloat angle, GLfloat, GLfloat, GLfloat);
void     P3_matrix_rotate_lateral       (GLfloat[19], GLfloat);
void     P3_matrix_rotate_vertical      (GLfloat[19], GLfloat);
void     P3_matrix_rotate_incline       (GLfloat[19], GLfloat);
void     P3_matrix_rotate_axe           (GLfloat[16], GLfloat angle, GLfloat, GLfloat, GLfloat);
void     P3_matrix_rotate               (GLfloat[19], GLfloat, GLfloat[3], GLfloat[3]);
void     P3_matrix_translate            (GLfloat[19], GLfloat, GLfloat, GLfloat);
void     P3_matrix_look_at_Z            (GLfloat[19], GLfloat[3]);
void     P3_matrix_look_at_Y            (GLfloat[19], GLfloat[3]);
void     P3_matrix_look_at_X            (GLfloat[19], GLfloat[3]);
void     P3_matrix_look_to_Z            (GLfloat[19], GLfloat[3]);
void     P3_matrix_look_to_Y            (GLfloat[19], GLfloat[3]);
void     P3_matrix_look_to_X            (GLfloat[19], GLfloat[3]);
void     P3_matrix_frustum              (GLfloat[19], GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat);
void     P3_matrix_print                (GLfloat[19], char*);
int      P3_matrix_is_direct            (GLfloat[19]);

void     P3_face_intersect_plane        (GLfloat*, int, GLfloat[4], GLfloat**, int*);
int      P3_sphere_raypick              (GLfloat* data, GLfloat sphere[4]);
int      P3_triangle_raypick            (GLfloat* data,
                                         GLfloat[3], GLfloat[3], GLfloat[3], GLfloat normal[3],
                                         int option, GLfloat* result);
int      P3_quad_raypick                (GLfloat* data,
                                         GLfloat p1[3], GLfloat p2[3], GLfloat p3[3], GLfloat p4[3], GLfloat normal[3],
                                         int option, GLfloat* result);
