/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * mesh_build.h
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/


void      P3_world_extract              (P3_world*, int class, P3_list*);
int       P3_model_index_f_normal       (P3_model*, GLfloat, GLfloat, GLfloat);
int       P3_model_index_coord          (P3_model*, GLfloat, GLfloat, GLfloat, int has_normal);
int       P3_model_index_color          (P3_model*, GLfloat, GLfloat, GLfloat, GLfloat);
int       P3_model_index_texcoord       (P3_model*, GLfloat, GLfloat);
int       P3_model_index_vertex         (P3_model*, int, int, int, int);
void      P3_model_finalize             (P3_model*);
P3_mesh*  P3_mesh_from_faces            (P3_model*, P3_list* faces, P3_material*, int meshoption);
P3_list*  P3_meshes_base_from_faces     (P3_model*, P3_list* given_faces, P3_list* lights);
P3_model* P3_model_from_faces           (P3_model*, P3_list* given_faces, P3_list* lights);
P3_model* P3_model_from_world           (P3_model*, P3_world*);
void      P3_faces_from_mesh            (P3_model*, P3_world* world);
void      P3_model_compute_static_light (P3_model*, P3_list* lights, int shadow);
