/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * xmesh_fileio.c
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 **********************************************/

#include "p3_base.h"
#include "util.h"
#include "material.h"
#include "mesh.h"


/*========+
 | SAVING |
 +========*/

int P3_xmesh_get_material_index (P3_xmesh* mesh, P3_material* material) {
  int i;
  for (i = 0; i < mesh->nb_materials; i++) {
    if (mesh->materials[i] == material) { return i; }
  }
  return -1;
}

void P3_xnode_get_data (P3_xnode* node, P3_xmesh* mesh, P3_chunk* chunk) {
  int i;
  P3_chunk_save_int (chunk, node->nb_faces);
  P3_chunk_save_int (chunk, node->nb_child);
  P3_chunk_save (chunk, node->sphere, 4 * sizeof (GLfloat));
  for (i = 0; i < node->nb_faces; i++) {
    P3_chunk_save_int (chunk, node->faces[i] - mesh->faces);
  }
  for (i = 0; i < node->nb_child; i++) {
    P3_xnode_get_data (node->child[i], mesh, chunk);
  }
}

void P3_xmesh_get_data (P3_xmesh* mesh, P3_chunk* chunk) {
  void* ptr;
  P3_xface* f;
  int i;
  /* mesh->option must be get by xmesh implementations */
  P3_chunk_save_int (chunk, mesh->nb_vertices);
  P3_chunk_save_int (chunk, mesh->nb_coords);
  P3_chunk_save_int (chunk, mesh->nb_vnormals);
  P3_chunk_save_int (chunk, mesh->nb_colors);
  P3_chunk_save_int (chunk, mesh->nb_values);
  P3_chunk_save_int (chunk, mesh->faces_size);
  P3_chunk_save (chunk, mesh->coords,   mesh->nb_coords   * 3 * sizeof (GLfloat));
  P3_chunk_save (chunk, mesh->vnormals, mesh->nb_vnormals * 3 * sizeof (GLfloat));
  P3_chunk_save (chunk, mesh->colors,   mesh->nb_colors   * 4 * sizeof (GLfloat));
  P3_chunk_save (chunk, mesh->values,   mesh->nb_values       * sizeof (GLfloat));
  for (i = 0; i < mesh->nb_vertices; i++)
    P3_chunk_save_int (chunk, mesh->vertex_coords[i] - mesh->coords);
  if (mesh->option & P3_MESH_VERTEX_OPTIONS)
    P3_chunk_add (chunk, mesh->vertex_options, mesh->nb_vertices * sizeof (char));
  if (mesh->option & P3_MESH_VERTEX_NORMALS) {
    for (i = 0; i < mesh->nb_vertices; i++)
      P3_chunk_save_int (chunk, mesh->vertex_normals[i] - mesh->vnormals);
  }
  if (mesh->option & P3_MESH_TEXCOORDS) {
    for (i = 0; i < mesh->nb_vertices; i++)
      P3_chunk_save_int (chunk, mesh->vertex_texcoords[i] - mesh->values);
  }
  if (mesh->option & P3_MESH_DIFFUSES) {
    for (i = 0; i < mesh->nb_vertices; i++)
      P3_chunk_save_int (chunk, mesh->vertex_diffuses[i] - mesh->values);
  }
  if (mesh->option & P3_MESH_EMISSIVES) {
    for (i = 0; i < mesh->nb_vertices; i++)
      P3_chunk_save_int (chunk, mesh->vertex_emissives[i] - mesh->values);
  }
  /* face */
  f = (P3_xface*) mesh->faces;
  while ((void*) f < mesh->faces + mesh->faces_size) {
    P3_chunk_save_int (chunk, f->option);
    P3_chunk_save_int (chunk, P3_xmesh_get_material_index (mesh, f->pack->material));
    P3_chunk_save_int (chunk, f->normal - mesh->values);
    P3_chunk_save_int (chunk, f->v1);
    P3_chunk_save_int (chunk, f->v2);
    P3_chunk_save_int (chunk, f->v3);
    if (f->option & P3_FACE_QUAD) {
      P3_chunk_save_int (chunk, f->v4);
      ptr = ((void*) f) + sizeof (int) + 4 * sizeof (int) + sizeof (P3_xpack*) + sizeof (GLfloat*);
    } else {
      ptr = ((void*) f) + sizeof (int) + 3 * sizeof (int) + sizeof (P3_xpack*) + sizeof (GLfloat*);
    }
    if (mesh->option & P3_MESH_NEIGHBORS) {
      if (*((P3_xface**) ptr) == NULL) P3_chunk_save_int (chunk, -1);
      else                             P3_chunk_save_int (chunk, ((void*) *((P3_xface**) ptr)) - mesh->faces);
      ptr += sizeof (P3_xface*);
      if (*((P3_xface**) ptr) == NULL) P3_chunk_save_int (chunk, -1);
      else                             P3_chunk_save_int (chunk, ((void*) *((P3_xface**) ptr)) - mesh->faces);
      ptr += sizeof (P3_xface*);
      if (*((P3_xface**) ptr) == NULL) P3_chunk_save_int (chunk, -1);
      else                             P3_chunk_save_int (chunk, ((void*) *((P3_xface**) ptr)) - mesh->faces);
      ptr += sizeof (P3_xface*);
      if (f->option & P3_FACE_QUAD) {
        if (*((P3_xface**) ptr) == NULL) P3_chunk_save_int (chunk, -1);
        else                             P3_chunk_save_int (chunk, ((void*) *((P3_xface**) ptr)) - mesh->faces);
        ptr += sizeof (P3_xface*);
      }
    }
    f = (P3_xface*) ptr;
  }
}


/*=========+
 | LOADING |
 +=========*/

P3_xnode* P3_xnode_set_data (P3_xmesh* mesh, P3_chunk* chunk) {
  P3_xnode* node;
  int i;
  node = (P3_xnode*) malloc (sizeof (P3_xnode));
  node->nb_faces = P3_chunk_load_int (chunk);
  node->nb_child = P3_chunk_load_int (chunk);
  node->faces = (void**) malloc (node->nb_faces * sizeof (void*));
  node->child = (P3_xnode**) malloc (node->nb_child * sizeof (P3_xnode*));
  P3_chunk_load (chunk, node->sphere, 4 * sizeof (GLfloat));
  for (i = 0; i < node->nb_faces; i++) {
    node->faces[i] = mesh->faces + P3_chunk_load_int (chunk);
  }
  for (i = 0; i < node->nb_child; i++) {
    node->child[i] = P3_xnode_set_data (mesh, chunk);
  }
  return node;
}

void P3_xmesh_set_data (P3_xmesh* mesh, P3_chunk* chunk) {
  void* ptr;
  P3_xface* f;
  int i;
  /* mesh->option must be get by xmesh implementations */
  mesh->nb_vertices = P3_chunk_load_int (chunk);
  mesh->nb_coords   = P3_chunk_load_int (chunk);
  mesh->nb_vnormals = P3_chunk_load_int (chunk);
  mesh->nb_colors   = P3_chunk_load_int (chunk);
  mesh->nb_values   = P3_chunk_load_int (chunk);
  mesh->faces_size  = P3_chunk_load_int (chunk);
  mesh->coords        = (GLfloat*)  malloc (mesh->nb_coords   * 3 * sizeof (GLfloat));
  mesh->vnormals      = (GLfloat*)  malloc (mesh->nb_vnormals * 3 * sizeof (GLfloat));
  mesh->colors        = (GLfloat*)  malloc (mesh->nb_colors   * 4 * sizeof (GLfloat));
  mesh->values        = (GLfloat*)  malloc (mesh->nb_values       * sizeof (GLfloat));
  mesh->vertex_coords = (GLfloat**) malloc (mesh->nb_vertices     * sizeof (GLfloat*));
  mesh->faces         =             malloc (mesh->faces_size);
  P3_chunk_load (chunk, mesh->coords,   mesh->nb_coords   * 3 * sizeof (GLfloat));
  P3_chunk_load (chunk, mesh->vnormals, mesh->nb_vnormals * 3 * sizeof (GLfloat));
  P3_chunk_load (chunk, mesh->colors,   mesh->nb_colors   * 4 * sizeof (GLfloat));
  P3_chunk_load (chunk, mesh->values,   mesh->nb_values       * sizeof (GLfloat));
  for (i = 0; i < mesh->nb_vertices; i++)
    mesh->vertex_coords[i] = mesh->coords + P3_chunk_load_int (chunk);
  if (mesh->option & P3_MESH_VERTEX_OPTIONS) {
    mesh->vertex_options = (char*) malloc (mesh->nb_vertices * sizeof (char));
    P3_chunk_get (chunk, mesh->vertex_options, mesh->nb_vertices * sizeof (char));
  }
  if (mesh->option & P3_MESH_VERTEX_NORMALS) {
    mesh->vertex_normals = (GLfloat**) malloc (mesh->nb_vertices * sizeof (GLfloat*));
    for (i = 0; i < mesh->nb_vertices; i++)
      mesh->vertex_normals[i] = mesh->vnormals + P3_chunk_load_int (chunk);
  }
  if (mesh->option & P3_MESH_TEXCOORDS) {
    mesh->vertex_texcoords = (GLfloat**) malloc (mesh->nb_vertices * sizeof (GLfloat*));
    for (i = 0; i < mesh->nb_vertices; i++)
      mesh->vertex_texcoords[i] = mesh->values + P3_chunk_load_int (chunk);
  }
  if (mesh->option & P3_MESH_DIFFUSES) {
    mesh->vertex_diffuses = (GLfloat**) malloc (mesh->nb_vertices * sizeof (GLfloat*));
    for (i = 0; i < mesh->nb_vertices; i++)
      mesh->vertex_diffuses[i] = mesh->values + P3_chunk_load_int (chunk);
  }
  if (mesh->option & P3_MESH_EMISSIVES) {
    mesh->vertex_emissives = (GLfloat**) malloc (mesh->nb_vertices * sizeof (GLfloat*));
    for (i = 0; i < mesh->nb_vertices; i++)
      mesh->vertex_emissives[i] = mesh->values + P3_chunk_load_int (chunk);
  }
  /* face */
  f = (P3_xface*) mesh->faces;
  while ((void*) f < mesh->faces + mesh->faces_size) {
    f->option = P3_chunk_load_int (chunk);
    i = P3_chunk_load_int (chunk);
    if (i == -1) 
      f->pack = P3_xpack_get (f->option, NULL);
//      f->pack = P3_xpack_get (f->option & P3_PACK_OPTIONS, NULL);
    else
      f->pack = P3_xpack_get (f->option, mesh->materials[i]);
//      f->pack = P3_xpack_get (f->option & P3_PACK_OPTIONS, mesh->materials[i]);
    f->normal = mesh->values + P3_chunk_load_int (chunk);
    f->v1 = P3_chunk_load_int (chunk);
    f->v2 = P3_chunk_load_int (chunk);
    f->v3 = P3_chunk_load_int (chunk);
    if (f->option & P3_FACE_QUAD) {
      f->v4 = P3_chunk_load_int (chunk);
      ptr = ((void*) f) + sizeof (int) + 4 * sizeof (int) + sizeof (P3_xpack*) + sizeof (GLfloat*);
    } else {
      ptr = ((void*) f) + sizeof (int) + 3 * sizeof (int) + sizeof (P3_xpack*) + sizeof (GLfloat*);
    }
    if (mesh->option & P3_MESH_NEIGHBORS) {
      i = P3_chunk_load_int (chunk);
      if (i == -1) *((P3_xface**) ptr) = NULL;
      else         *((P3_xface**) ptr) = mesh->faces + i;
      ptr += sizeof (P3_xface*);
      i = P3_chunk_load_int (chunk);
      if (i == -1) *((P3_xface**) ptr) = NULL;
      else         *((P3_xface**) ptr) = mesh->faces + i;
      ptr += sizeof (P3_xface*);
      i = P3_chunk_load_int (chunk);
      if (i == -1) *((P3_xface**) ptr) = NULL;
      else         *((P3_xface**) ptr) = mesh->faces + i;
      ptr += sizeof (P3_xface*);
      if (f->option & P3_FACE_QUAD) {
        i = P3_chunk_load_int (chunk);
        if (i == -1) *((P3_xface**) ptr) = NULL;
        else         *((P3_xface**) ptr) = mesh->faces + i;
        ptr += sizeof (P3_xface*);
      }
    }
    f = (P3_xface*) ptr;
  }
}

