/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * mesh.c
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 **********************************************/

#include "p3_base.h"
#include "math3d.h"
#include "frustum.h"
#include "coordsys.h"
#include "renderer.h"
#include "util.h"
#include "mesh.h"

extern P3_renderer* renderer;


P3_class P3_class_mesh_LOD = {
  P3_ID_MESH_LOD,
  (batch_func)     P3_mesh_LOD_batch,
  (render_func)    0,
  (shadow_func)    0,
  (raypick_func)   P3_mesh_LOD_raypick,
  (raypick_b_func) P3_mesh_LOD_raypick_b,
};


P3_mesh_LOD* P3_mesh_LOD_new (P3_mesh_LOD* mesh) {
  if (mesh == NULL) mesh = (P3_mesh_LOD*) malloc (sizeof (P3_mesh_LOD));
  mesh->class = &P3_class_mesh_LOD;
  mesh->nb_meshes = 0;
  mesh->meshes = NULL;
  mesh->LOD_factor = 0.2;
  return mesh;
}

void P3_mesh_LOD_dealloc (P3_mesh_LOD* mesh) {
  free (mesh->meshes);
}


/*============+
 | RAYPICKING |
 +============*/

void P3_mesh_LOD_raypick (P3_mesh_LOD* mesh, P3_raypick_data* data, P3_raypickable* parent) {
  /* always raypick with the most accurate mesh (= the 1rst one) */
  P3_mesh_raypick (mesh->meshes[0], data, parent);
}

int P3_mesh_LOD_raypick_b (P3_mesh_LOD* mesh, P3_raypick_data* data, P3_raypickable* parent) {
  /* always raypick with the most accurate mesh (= the 1rst one) */
  return P3_mesh_raypick_b (mesh->meshes[0], data, parent);
}


/*===========+
 | RENDERING |
 +===========*/

void P3_mesh_LOD_batch (P3_mesh_LOD* mesh, P3_instance* inst) {
  P3_frustum* frustum = P3_renderer_get_frustum (inst);
  P3_mesh* m = mesh->meshes[0];
  GLfloat d;
  int n;
  if (m->option & P3_MESH_HAS_SPHERE) { 
    if (P3_sphere_in_frustum (frustum, (GLfloat*) m->xtra2) == P3_FALSE) return; 
    d = P3_point_distance_to ((GLfloat*) m->xtra2, frustum->position);
  } else {
    d = P3_vector_length (frustum->position);
  }
  n = (int) (d * mesh->LOD_factor);
  if (n >= mesh->nb_meshes) n = mesh->nb_meshes - 1;
  m = mesh->meshes[n];
  /* don't want make twice the frustum test */
  n = m->option;
  m->option  &= ~P3_MESH_HAS_SPHERE;
  P3_mesh_batch (m, inst);
  m->option = n;
}


/*==================+
 | SAVING / LOADING |
 +==================*/

void P3_mesh_LOD_get_data (P3_mesh_LOD* mesh, P3_chunk* chunk) {
  P3_chunk_add_float (chunk, mesh->LOD_factor);
}

void P3_mesh_LOD_set_data (P3_mesh_LOD* mesh, P3_chunk* chunk) {
  mesh->LOD_factor = P3_chunk_get_float (chunk);
}



