/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

/*========+
 | CAMERA |
 +========*/

/*---------+
 | Methods |
 +---------*/

static int PyP3Camera_Init (P3_camera* a, PyObject* args, PyObject* kwds) {
  P3_camera_new (a);
  return 0;
}

static void PyP3Camera_Dealloc (P3_camera* a) {
  PyObject_GC_UnTrack ((PyObject*) a);
  Py_XDECREF (a->to_render);
  a->ob_type->tp_free ((PyObject*) a); 
}

static int PyP3Camera_Traverse (P3_camera* a, visitproc visit, void* arg) {
  int err;
  if (a->to_render != NULL) {
    err = visit ((PyObject*) a->to_render, arg);
    if (err) { return err; }
  }
  return 0;
}

static int PyP3Camera_Clear (P3_camera* a) {
  Py_XDECREF (a->to_render);
  a->to_render = NULL;
  return 0;
}

static PyObject* PyP3Camera_GetState (P3_camera* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_camera_get_data (a, chunk);
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
  if (a->to_render == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 1, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->to_render);
    PyTuple_SET_ITEM (tuple, 1, (PyObject*) a->to_render);
  }
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Camera_SetState (P3_camera* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_camera_set_data (a, chunk);
  a->to_render = (P3_any_object*) PySequence_Fast_GET_ITEM (args, 2);
  if ((PyObject*) a->to_render == Py_None) {
    a->to_render = NULL;
  } else {
    Py_INCREF ((PyObject*) a->to_render);
  }
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3Camera_Render (P3_camera* a) {
  P3_camera_render (a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Camera_Methods[] = {
//  PYP3_COORDSYS_FUNCS,
  { "render",    (PyCFunction) PyP3Camera_Render,   METH_NOARGS },
  { "_getstate", (PyCFunction) PyP3Camera_GetState, METH_NOARGS },
  { "_setstate", (PyCFunction) PyP3Camera_SetState, METH_O },
  { NULL, NULL } /* sentinel */
};

/*---------+
 | Get Set |
 +---------*/

PY_GET_SET_ON_OBJECT     (Camera, P3_camera*, ToRender, to_render, P3_any_object*)
PY_GET_SET_ON_INT        (Camera, P3_camera*, Left, size[0])
PY_GET_SET_ON_INT        (Camera, P3_camera*, Top,  size[1])
PY_GET_SET_ON_OPTION     (Camera, P3_camera*, Partial, P3_CAMERA_PARTIAL)
PY_GET_SET_ON_FLOAT_ADD  (Camera, P3_camera*, Front, front, P3_camera_set (a);)
PY_GET_SET_ON_FLOAT_ADD  (Camera, P3_camera*, Back, back, P3_camera_set (a);)
PY_GET_SET_ON_FLOAT_ADD  (Camera, P3_camera*, Fov, fov, P3_camera_set (a);)
PY_GET_SET_ON_INT_ADD    (Camera, P3_camera*, Width, size[2], P3_camera_set (a);)
PY_GET_SET_ON_INT_ADD    (Camera, P3_camera*, Height, size[3], P3_camera_set (a);)
PY_GET_SET_ON_OPTION_ADD (Camera, P3_camera*, Ortho, P3_CAMERA_ORTHO, P3_camera_set (a);)

static PyGetSetDef PyP3Camera_GetSets[] = {
//  PYP3_COORDSYS_GETSETS, 
//  PYP3_CHILD_GETSETS,
  { "to_render", (getter) PyP3Camera_GetToRender, (setter) PyP3Camera_SetToRender, NULL },
  { "front",     (getter) PyP3Camera_GetFront,    (setter) PyP3Camera_SetFront,    NULL },
  { "back",      (getter) PyP3Camera_GetBack,     (setter) PyP3Camera_SetBack,     NULL },
  { "fov",       (getter) PyP3Camera_GetFov,      (setter) PyP3Camera_SetFov,      NULL },
  { "left",      (getter) PyP3Camera_GetLeft,     (setter) PyP3Camera_SetLeft,     NULL },
  { "top",       (getter) PyP3Camera_GetTop,      (setter) PyP3Camera_SetTop,      NULL },
  { "width",     (getter) PyP3Camera_GetWidth,    (setter) PyP3Camera_SetWidth,    NULL },
  { "height",    (getter) PyP3Camera_GetHeight,   (setter) PyP3Camera_SetHeight,   NULL },
  { "partial",   (getter) PyP3Camera_GetPartial,  (setter) PyP3Camera_SetPartial,  NULL },
  { "ortho",     (getter) PyP3Camera_GetOrtho,    (setter) PyP3Camera_SetOrtho,    NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Camera_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Camera",
  sizeof(P3_camera),
  0,
  (destructor) PyP3Camera_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Camera_Traverse,/* tp_traverse */
  (inquiry) PyP3Camera_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Camera_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Camera_GetSets,/* tp_getset */
  &PyP3Element_Type,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Camera_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

