/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

/*===========*
 * PARTICLES *
 *===========*/

int PyP3Particles_Generator (P3_particles* p, int index) {
  PyObject* o;
  int i;
  o = PyObject_CallMethod ((PyObject*) p, "generate", "i", index);
  if (PyObject_IsTrue (o)) { i = P3_TRUE; } else { i = P3_FALSE; }
  Py_XDECREF (o);
  return i;
}

/*---------+
 | Methods |
 +---------*/

static int PyP3Particles_Traverse (P3_particles* w, visitproc visit, void* arg) {
	int err;
  if (w->parent != NULL) {
    err = visit ((PyObject*) w->parent, arg);
    if (err) { return err; }
  }
  if (w->coordsys != NULL) {
    err = visit ((PyObject*) w->coordsys, arg);
    if (err) { return err; }
  }
  if (w->material != NULL) {
    err = visit ((PyObject*) w->material, arg);
    if (err) { return err; }
  }
	return 0;
}

static int PyP3Particles_Clear (P3_particles* self) {
  Py_XDECREF (self->parent);
  Py_XDECREF (self->material);
  Py_XDECREF (self->coordsys);
  self->parent   = NULL;
  self->material = NULL;
  self->coordsys = NULL;
  return 0;
}

static int PyP3Particles_Init (PyObject* self, PyObject* args, PyObject* kwds) {
  P3_particles_new ((P3_particles*) self);
	return 0;
}

static void PyP3Particles_Dealloc (P3_particles* w) {
  P3_particles_free_data (w);
  PyObject_GC_UnTrack ((PyObject*) w);
  Py_XDECREF (w->parent);
  Py_XDECREF (w->material);
  Py_XDECREF (w->coordsys);
  w->ob_type->tp_free ((PyObject*) w);
}

static PyObject* PyP3Particles_AdvanceTime (P3_particles* p, PyObject* arg) {
  P3_particles_advance_time (p, (GLfloat) PyFloat_AS_DOUBLE (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Particles_SetParticle (P3_particles* p, PyObject* args) {
  GLfloat* particle;
  PyObject* o;
  /* args are: (index, life, (speed x, y, z), (acceleration x, y, z), [direction x, y, z]) */
  particle = P3_particles_generate (p, (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0)), (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)));
  o = PySequence_Fast_GET_ITEM (args, 2);
  particle[5] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
  particle[6] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
  particle[7] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
  o = PySequence_Fast_GET_ITEM (args, 3);
  particle[ 8] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
  particle[ 9] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
  particle[10] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
  if (PySequence_Size (args) == 5) {
    int i = 11;
    if (p->option & P3_PARTICLES_COLOREDS)   { i += 4; }
    if (p->option & P3_PARTICLES_MULTI_SIZE) { i += 2; }
    o = PySequence_Fast_GET_ITEM (args, 4);
    particle[i]     = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
    particle[i + 1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
    particle[i + 2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Particles_SetParticleAll (P3_particles* p, PyObject* args) {
  GLfloat* particle;
  PyObject* o;
  int index;
  /* args are: (index, life, (position x, y, z), (speed x, y, z), (acceleration x, y, z), [direction x, y, z]) */
  index = (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0));
  particle = p->particles + index * p->particle_size;
  particle[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  particle[1] = particle[0];
  if (p->option & P3_PARTICLES_COLOREDS) {
    memcpy (particle + 11, p->fading_colors, 4 * sizeof (GLfloat));
  }
  if (p->option & P3_PARTICLES_MULTI_SIZE) {
    if (p->option & P3_PARTICLES_COLOREDS) {
      memcpy (particle + 15, p->sizes, 2 * sizeof (GLfloat));
    } else {
      memcpy (particle + 11, p->sizes, 2 * sizeof (GLfloat));
    }
  }
  if (p->nb <= index) { p->nb = index + 1; }
  o = PySequence_Fast_GET_ITEM (args, 2);
  particle[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
  particle[3] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
  particle[4] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
  o = PySequence_Fast_GET_ITEM (args, 3);
  particle[5] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
  particle[6] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
  particle[7] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
  o = PySequence_Fast_GET_ITEM (args, 4);
  particle[ 8] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
  particle[ 9] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
  particle[10] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
  if (PySequence_Size (args) == 6) {
    int i = 11;
    if (p->option & P3_PARTICLES_COLOREDS)   { i += 4; }
    if (p->option & P3_PARTICLES_MULTI_SIZE) { i += 2; }
    o = PySequence_Fast_GET_ITEM (args, 5);
    particle[i]     = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
    particle[i + 1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
    particle[i + 2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Particles_GetParticlePosition (P3_particles* p, PyObject* arg) {
  PyObject* o;
  int index = (int) PyInt_AS_LONG (arg);
  GLfloat* particle = p->particles + index * p->particle_size;
  o = PyTuple_New (3);
  PyTuple_SET_ITEM (o, 0, PyFloat_FromDouble ((double) particle[2]));
  PyTuple_SET_ITEM (o, 1, PyFloat_FromDouble ((double) particle[3]));
  PyTuple_SET_ITEM (o, 2, PyFloat_FromDouble ((double) particle[4]));
  return o;
}

static PyObject* PyP3Particles_SetColors (P3_particles* p, PyObject* args) {
  if (args == NULL || args == Py_None || PySequence_Size (args) == 0) {
    p->nb_colors = 0;
    free (p->fading_colors);
    p->fading_colors = NULL;
    if (p->option & P3_SPRITE_COLORED) { p->option -= P3_SPRITE_COLORED; }
    if (p->option & P3_PARTICLES_COLOREDS) { p->option -= P3_PARTICLES_COLOREDS; }
  } else {
    PyObject* o;
    int i; int j;
    p->nb_colors = PySequence_Size (args);
    p->fading_colors = (GLfloat*) realloc (p->fading_colors, p->nb_colors * 4 * sizeof (GLfloat));
    for (i = 0; i < p->nb_colors; i++) {
      o = PySequence_Fast_GET_ITEM (args, i);
      for (j = 0; j < 4; j++) {
        p->fading_colors[i * 4 + j] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, j));
      }
    }
    if (p->nb_colors == 1) {
      p->option |= P3_SPRITE_COLORED;
      if (p->option & P3_PARTICLES_COLOREDS) { p->option -= P3_PARTICLES_COLOREDS; }
    } else {
      p->option |= P3_SPRITE_COLORED;
      p->option |= P3_PARTICLES_COLOREDS;
    }
  }
  P3_particles_compute_alpha (p);
  P3_particles_init (p);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Particles_SetSizes (P3_particles* p, PyObject* args) {
  if (args == NULL || args == Py_None || PySequence_Size (args) == 0) {
    p->nb_sizes = 1;
    p->sizes = (GLfloat*) realloc (p->sizes, 2 * sizeof (GLfloat));
    p->sizes[0] = 1.0;
    p->sizes[1] = 1.0;
    if (p->option & P3_PARTICLES_MULTI_SIZE) { p->option -= P3_PARTICLES_MULTI_SIZE; }
  } else {
    PyObject* o;
    int i;
    p->nb_sizes = PySequence_Size (args);
    p->sizes = (GLfloat*) realloc (p->sizes, p->nb_sizes * 2 * sizeof (GLfloat));
    for (i = 0; i < p->nb_sizes; i++) {
      o = PySequence_Fast_GET_ITEM (args, i);
      p->sizes[i * 2]     = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
      p->sizes[i * 2 + 1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
    }
    if (p->nb_sizes == 1) {
      if (p->option & P3_PARTICLES_MULTI_SIZE) { p->option -= P3_PARTICLES_MULTI_SIZE; }
    } else {
      p->option |= P3_PARTICLES_MULTI_SIZE;
    }
  }
  P3_particles_init (p);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Particles_GetState (P3_particles* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_particles_get_data (a, chunk);
  tuple = PyTuple_New (3);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
  if (a->material == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 1, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->material);
    PyTuple_SET_ITEM (tuple, 1, (PyObject*) a->material);
  }
  if (a->coordsys == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 2, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->coordsys);
    PyTuple_SET_ITEM (tuple, 2, (PyObject*) a->coordsys);
  }
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Particles_SetState (P3_particles* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_particles_set_data (a, chunk);
  if (P3_chunk_get_char (chunk) == '\0') {
    a->generator = 0;
  } else {
    a->generator = PyP3Particles_Generator;
  }
  a->material = (P3_material*) PySequence_Fast_GET_ITEM (args, 1);
  if ((PyObject*) a->material == Py_None) {
    a->material = NULL;
  } else {
    Py_INCREF ((PyObject*) a->material);
  }
  a->coordsys = (P3_coordsys*) PySequence_Fast_GET_ITEM (args, 2);
  if ((PyObject*) a->coordsys == Py_None) {
    a->coordsys = NULL;
  } else {
    Py_INCREF ((PyObject*) a->coordsys);
  }
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Particles_Methods[] = {
//  PYP3_COORDSYS_FUNCS,
  { "_getstate",             (PyCFunction) PyP3Particles_GetState,            METH_NOARGS },
  { "_setstate",             (PyCFunction) PyP3Particles_SetState,            METH_O },
  { "_advance_time",         (PyCFunction) PyP3Particles_AdvanceTime,         METH_O },
  { "set_colors",            (PyCFunction) PyP3Particles_SetColors,           METH_VARARGS },
  { "set_sizes",             (PyCFunction) PyP3Particles_SetSizes,            METH_VARARGS },
  { "set_particle",          (PyCFunction) PyP3Particles_SetParticle,         METH_VARARGS },
  { "set_particle_all",      (PyCFunction) PyP3Particles_SetParticleAll,      METH_VARARGS },
  { "get_particle_position", (PyCFunction) PyP3Particles_GetParticlePosition, METH_O },
  { NULL, NULL }
};

/*---------+
 | Get Set |
 +---------*/

PY_GET_SET_ON_OBJECT     (Particles, P3_particles*, Coordsys, coordsys, P3_coordsys*)
PY_GET_SET_ON_OBJECT_ADD (Particles, P3_particles*, Material, material, P3_material*, P3_particles_compute_alpha (a);)
PY_GET_SET_ON_INT_ADD    (Particles, P3_particles*, MaxNb, max_nb, a->particles = (GLfloat*) realloc (a->particles, a->max_nb * a->particle_size * sizeof (GLfloat));)
PY_GET_SET_ON_INT        (Particles, P3_particles*, Nb, nb)

static PyObject* PyP3Particles_GetGenerator (P3_particles* p, void* context) {
  if (p->generator == 0) { return PyInt_FromLong (0); } else { return PyInt_FromLong (1); }
}

static int PyP3Particles_SetGenerator (P3_particles* p, PyObject* value, void* context) {
  if (PyObject_IsTrue (value) == 1) {
    p->generator = PyP3Particles_Generator;
  } else {
    p->generator = 0;
  }
  return 0;
}

static PyGetSetDef PyP3Particles_GetSets[] = {
//  PYP3_VISIBLE_GETSETS,
//  PYP3_CHILD_GETSETS,
//  PYP3_COORDSYS_GETSETS,
  { "material",                (getter) PyP3Particles_GetMaterial,  (setter) PyP3Particles_SetMaterial,  NULL },
  { "nb_max",                  (getter) PyP3Particles_GetMaxNb,     (setter) PyP3Particles_SetMaxNb,     NULL },
  { "nb",                      (getter) PyP3Particles_GetNb,        (setter) PyP3Particles_SetNb,        NULL },
  { "auto_generate_particle",  (getter) PyP3Particles_GetGenerator, (setter) PyP3Particles_SetGenerator, NULL },
  { "particle_coordsys",       (getter) PyP3Particles_GetCoordsys,  (setter) PyP3Particles_SetCoordsys,  NULL },
  { "lit",                     (getter) PyP3Sprite_GetLit,          (setter) PyP3Sprite_SetLit,          NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Particles_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Particles",
  sizeof(P3_particles),
  0,
  (destructor) PyP3Particles_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,//Py_TPFLAGS_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Particles_Traverse,/* tp_traverse */
  (inquiry) PyP3Particles_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Particles_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Particles_GetSets,/* tp_getset */
  &PyP3Element_Type,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Particles_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};


