/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 **************************************************************/

/*============================*
 * SPRITE PARTICULE FUNCTIONS *
 *============================*/

PyObject* PyP3SpritesSphere_Render (PyObject* module, PyObject* args) {
//  P3_parent* coordsys;
  P3_coordsys* root;
//  P3_parent* root;
  PyObject* sprites;
  PyObject* sprite;
  PyObject* o;
  GLfloat position[3];
  GLfloat color[4];
  GLfloat w; GLfloat h; /* size of the sprite */
  int i;
  int nb;
// TO DO coordsys is useless...
  /* args : (coordsys, [particules]) */
//  coordsys = (P3_parent*) PySequence_Fast_GET_ITEM (args, 0);
  sprites = PySequence_Fast_GET_ITEM (args, 1);
  nb = PySequence_Size (sprites);
  root = (P3_coordsys*) renderer->c_camera;
//  root = (P3_parent*) P3_coordsys_get_root ((P3_coordsys*) coordsys);
  glLoadIdentity ();
//  glLoadMatrixf (root->render_matrix);
  glDisable (GL_CULL_FACE);
  /* use default activated material :) */
  glBegin (GL_QUADS);
  for (i = 0; i < nb; i++) {
    sprite = PySequence_Fast_GET_ITEM (sprites, i);
    o = PyObject_GetAttrString (sprite, "x");
    position[0] = (GLfloat) PyFloat_AS_DOUBLE (o);
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "y");
    position[1] = (GLfloat) PyFloat_AS_DOUBLE (o);
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "z");
    position[2] = (GLfloat) PyFloat_AS_DOUBLE (o);
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "parent");
    if (o != (PyObject*) root) {
      if (o != Py_None) {
//        P3_point_by_matrix (position, ((P3_parent*) o)->render_matrix);
        P3_point_by_matrix (position, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
      }
      P3_point_by_matrix (position, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) root));
    }
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "color");
    color[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
    color[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
    color[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
    color[3] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 3));
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "width");
    w = (GLfloat) PyFloat_AS_DOUBLE (o);
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "height");
    h = (GLfloat) PyFloat_AS_DOUBLE (o);
    Py_DECREF (o);
    /* draw */
    glColor4fv (color);
    glTexCoord2f (0.0, 0.0); 
    glVertex3f (position[0] - w, position[1] - h, position[2]);
    glTexCoord2f (1.0, 0.0); 
    glVertex3f (position[0] + w, position[1] - h, position[2]);
    glTexCoord2f (1.0, 1.0); 
    glVertex3f (position[0] + w, position[1] + h, position[2]);
    glTexCoord2f (0.0, 1.0); 
    glVertex3f (position[0] - w, position[1] + h, position[2]);
  }
  glEnd ();
  glEnable (GL_CULL_FACE);
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3SpritesSphere_RenderOld (PyObject* module, PyObject* args) {
//  P3_parent* coordsys;
  P3_coordsys* root;
//  P3_parent* root;
  PyObject* sprites;
  PyObject* sprite;
  PyObject* old;
  PyObject* o;
  GLfloat position[3];
  GLfloat color[4];
  GLfloat w; GLfloat h; /* size of the sprite */
  int i; int j;
  int nb; int nb2;
  GLfloat a_incr;
// TO DO
  /* args : (coordsys, [particules], alpha cste) */
//  coordsys = (P3_parent*) PySequence_Fast_GET_ITEM (args, 0);
  sprites = PySequence_Fast_GET_ITEM (args, 1);
  nb = PySequence_Size (sprites);
//  root = (P3_parent*) P3_coordsys_get_root ((P3_coordsys*) coordsys);
  root = (P3_coordsys*) renderer->c_camera;
  a_incr = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  glLoadIdentity ();
//  glLoadMatrixf (root->render_matrix);
  glDisable (GL_CULL_FACE);
  /* use default activated material :) */
  glBegin (GL_QUADS);
  for (i = 0; i < nb; i++) {
    sprite = PySequence_Fast_GET_ITEM (sprites, i);
    o = PyObject_GetAttrString (sprite, "color");
    color[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0));
    color[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1));
    color[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 2));
    color[3] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 3));
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "width");
    w = (GLfloat) PyFloat_AS_DOUBLE (o);
    Py_DECREF (o);
    o = PyObject_GetAttrString (sprite, "height");
    h = (GLfloat) PyFloat_AS_DOUBLE (o);
    Py_DECREF (o);
    old = PyObject_GetAttrString (sprite, "old_pos");
    nb2 = PySequence_Size (old);
    for (j = 0; j < nb2; j++) {
      sprite = PySequence_Fast_GET_ITEM (old, j);
      o = PyObject_GetAttrString (sprite, "x");
      position[0] = (GLfloat) PyFloat_AS_DOUBLE (o);
      Py_DECREF (o);
      o = PyObject_GetAttrString (sprite, "y");
      position[1] = (GLfloat) PyFloat_AS_DOUBLE (o);
      Py_DECREF (o);
      o = PyObject_GetAttrString (sprite, "z");
      position[2] = (GLfloat) PyFloat_AS_DOUBLE (o);
      Py_DECREF (o);
      o = PyObject_GetAttrString (sprite, "parent");
      if (o != (PyObject*) root) {
        if (o != Py_None) {
          P3_point_by_matrix (position, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
        }
        P3_point_by_matrix (position, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) root));
      }
      Py_DECREF (o);
      glColor4fv (color);
      glTexCoord2f (0.0, 0.0); 
      glVertex3f (position[0] - w, position[1] - h, position[2]);
      glTexCoord2f (1.0, 0.0); 
      glVertex3f (position[0] + w, position[1] - h, position[2]);
      glTexCoord2f (1.0, 1.0); 
      glVertex3f (position[0] + w, position[1] + h, position[2]);
      glTexCoord2f (0.0, 1.0); 
      glVertex3f (position[0] - w, position[1] + h, position[2]);
      color[3] += a_incr;
    }
    Py_DECREF (old);
  }
  glEnd ();
  glEnable (GL_CULL_FACE);
  Py_INCREF (Py_None);
  return Py_None;
}

/*=========================*
 * FADING COLORS FUNCTIONS *
 *=========================*/

PyObject* PyP3FadingColor_Advance (PyObject* module, PyObject* self) {
  GLfloat life;
  GLfloat max_life;
  PyObject* colors;
  PyObject* color;
  PyObject* o;
  colors = PyObject_GetAttrString (self, "colors");
  color = PyObject_GetAttrString (self, "color");
  o = PyObject_GetAttrString (self, "life");
  life = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (self, "max_life");
  max_life = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  /* maximum life of a particle is assumed to be 1.0 */
  if (life <= 0.0) {
    int i;
    o = PySequence_Fast_GET_ITEM (colors, PySequence_Size (colors) - 1);
    for (i = 0; i < 4; i++) {
      PySequence_SetItem (color, i, PySequence_Fast_GET_ITEM (o, i));
    }
  } else if (life >= max_life) {
    int i;
    o = PySequence_Fast_GET_ITEM (colors, 0);
    for (i = 0; i < 4; i++) {
      PySequence_SetItem (color, i, PySequence_Fast_GET_ITEM (o, i));
    }
  } else {
    int nb = PySequence_Size (colors);
    int index;
    int i;
    GLfloat f1; GLfloat f2;
    GLfloat c1[4]; GLfloat c2[4];
    life = (1.0 - (life / max_life)) * (nb - 1);
    index = (int) life;
    o = PySequence_Fast_GET_ITEM (colors, index);
    for (i = 0; i < 4; i++) {
      c1[i] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, i));
    }
    o = PySequence_Fast_GET_ITEM (colors, index + 1);
    for (i = 0; i < 4; i++) {
      c2[i] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, i));
    }
    f2 = life - index;
    f1 = 1.0 - f2;
    o = PyFloat_FromDouble ((double) c1[0] * f1 + c2[0] * f2);
    PySequence_SetItem (color, 0, o);
    Py_DECREF (o);
    o = PyFloat_FromDouble ((double) c1[1] * f1 + c2[1] * f2);
    PySequence_SetItem (color, 1, o);
    Py_DECREF (o);
    o = PyFloat_FromDouble ((double) c1[2] * f1 + c2[2] * f2);
    PySequence_SetItem (color, 2, o);
    Py_DECREF (o);
    o = PyFloat_FromDouble ((double) c1[3] * f1 + c2[3] * f2);
    PySequence_SetItem (color, 3, o);
    Py_DECREF (o);
  }
  Py_DECREF (colors);
  Py_DECREF (color);
  Py_INCREF (Py_None);
  return Py_None;
}

/*========================*
 * ACCELERATION FUNCTIONS *
 *========================*/

PyObject* PyP3Acceleration_Advance (PyObject* module, PyObject* args) {
  PyObject* self;
  PyObject* acc;
  PyObject* speed;
  PyObject* o;
  double d;
  double sx; double sy; double sz;
  double proportion;
  /* args are: (self, acceleration, proportion) */
  self = PySequence_Fast_GET_ITEM (args, 0);
  acc  = PySequence_Fast_GET_ITEM (args, 1);
  proportion = PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  speed = PyObject_GetAttrString (self, "speed");
  o = PyObject_GetAttrString (speed, "x");
  d = PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  sx = d + PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (acc, 0));
  o = PyFloat_FromDouble (sx);
  PyObject_SetAttrString (speed, "x", o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (speed, "y");
  d = PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  sy = d + PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (acc, 1));
  o = PyFloat_FromDouble (sy);
  PyObject_SetAttrString (speed, "y", o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (speed, "z");
  d = PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  sz = d + PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (acc, 2));
  o = PyFloat_FromDouble (sz);
  PyObject_SetAttrString (speed, "z", o);
  Py_DECREF (o);
  Py_DECREF (speed);
  o = PyObject_GetAttrString (self, "x");
  d = PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyFloat_FromDouble (d + sx * proportion);
  PyObject_SetAttrString (self, "x", o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (self, "y");
  d = PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyFloat_FromDouble (d + sy * proportion);
  PyObject_SetAttrString (self, "y", o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (self, "z");
  d = PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyFloat_FromDouble (d + sz * proportion);
  PyObject_SetAttrString (self, "z", o);
  Py_DECREF (o);
  Py_INCREF (Py_None);
  return Py_None;
}


/*========+
 | SPRITE |
 +========*/

/*---------+
 | Methods |
 +---------*/

static int PyP3Sprite_Init (P3_sprite* a, PyObject* args, PyObject* kwds) {
  P3_sprite_new (a);
  return 0;
}

static void PyP3Sprite_Dealloc (P3_sprite* a) {
  PyObject_GC_UnTrack ((PyObject*) a);
  Py_XDECREF (a->material);
  a->ob_type->tp_free ((PyObject*) a); 
}

static int PyP3Sprite_Traverse (P3_sprite* a, visitproc visit, void* arg) {
  int err;
  if (a->material != NULL) {
    err = visit ((PyObject*) a->material, arg);
    if (err) { return err; }
  }
  return 0;
}

static int PyP3Sprite_Clear (P3_sprite* a) {
  Py_XDECREF (a->material);
  a->material = NULL;
  return 0;
}

static PyObject* PyP3Sprite_GetState (P3_sprite* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_sprite_get_data (a, chunk);
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
  if (a->material == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 1, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->material);
    PyTuple_SET_ITEM (tuple, 1, (PyObject*) a->material);
  }
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Sprite_SetState (P3_sprite* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_sprite_set_data (a, chunk);
  a->material = (P3_material*) PySequence_Fast_GET_ITEM (args, 1);
  if ((PyObject*) a->material == Py_None) {
    a->material = NULL;
  } else {
    Py_INCREF ((PyObject*) a->material);
  }
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Sprite_Translate (P3_sprite* a, PyObject* arg) {
  a->position[0] += (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0));
  a->position[1] += (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1));
  a->position[2] += (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Sprite_SetXyz (P3_sprite* a, PyObject* arg) {
  a->position[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 0));
  a->position[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 1));
  a->position[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (arg, 2));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Sprite_Add (P3_sprite* a, P3_vector* arg) {
  P3_point* new;
  new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF ((PyObject*) new->parent);
  if (arg->parent == NULL || a->parent == NULL || a->parent == arg->parent) {
    new->coord[0] = a->position[0] + arg->coord[0];
    new->coord[1] = a->position[1] + arg->coord[1];
    new->coord[2] = a->position[2] + arg->coord[2];
  } else {
    P3_vector_by_matrix_copy (new->coord, arg->coord, P3_coordsys_get_root_matrix (arg->parent));
    P3_vector_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix (a->parent));
    new->coord[0] += a->position[0];
    new->coord[1] += a->position[1];
    new->coord[2] += a->position[2];
  }
  return (PyObject*) new;
}

static PyObject* PyP3Sprite_Sub (P3_sprite* a, P3_vector* arg) {
  P3_point* new;
  new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF ((PyObject*) new->parent);
  if (arg->parent == NULL || a->parent == NULL || a->parent == arg->parent) {
    new->coord[0] = a->position[0] - arg->coord[0];
    new->coord[1] = a->position[1] - arg->coord[1];
    new->coord[2] = a->position[2] - arg->coord[2];
  } else {
    P3_vector_by_matrix_copy (new->coord, arg->coord, P3_coordsys_get_root_matrix (arg->parent));
    P3_vector_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix (a->parent));
    new->coord[0] = a->position[0] - new->coord[0];
    new->coord[1] = a->position[1] - new->coord[1];
    new->coord[2] = a->position[2] - new->coord[2];
  }
  return (PyObject*) new;
}

static PyObject* PyP3Sprite_Mod (P3_sprite* a, PyObject* arg) {
  if (arg == Py_None) arg = NULL;
  if ((PyObject*) a->parent == arg) {
    Py_INCREF ((PyObject*) a);
    return (PyObject*) a;
  } else {
    P3_point* new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
    new->parent = (P3_coordsys*) arg;
    if (arg != NULL) Py_INCREF (arg);
    if (a->parent == NULL || arg == NULL) {
      memcpy (new->coord, a->position, 3 * sizeof (GLfloat));
    } else {
      P3_point_by_matrix_copy (new->coord, a->position, P3_coordsys_get_root_matrix (a->parent));
      P3_point_by_matrix (new->coord, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) arg));
    }
    return (PyObject*) new;
  }
}

static PyObject* PyP3Sprite_Position (P3_sprite* a) {
  P3_point* new = (P3_point*) PyP3Point_Type.tp_alloc (&PyP3Point_Type, 0);
  memcpy (new->coord, a->position, 3 * sizeof (GLfloat));
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF ((PyObject*) new->parent);
  return (PyObject*) new;
}

static PyObject* PyP3Sprite_Move (P3_sprite* a, PyObject* arg) {
  PyP3_GetPositionInto (arg, a->parent, a->position);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Sprite_AddVector (P3_sprite* a, P3_vector* arg) {
  if (arg->parent == NULL || a->parent == NULL || a->parent == arg->parent) {
    a->position[0] += arg->coord[0];
    a->position[1] += arg->coord[1];
    a->position[2] += arg->coord[2];
  } else {
    GLfloat tmp[3];
    P3_vector_by_matrix_copy (tmp, arg->coord, P3_coordsys_get_root_matrix (arg->parent));
    P3_vector_by_matrix (tmp, P3_coordsys_get_inverted_root_matrix (a->parent));
    a->position[0] += tmp[0];
    a->position[1] += tmp[1];
    a->position[2] += tmp[2];
  }
  Py_INCREF ((PyObject*) a);
  return (PyObject*) a;
}

static PyObject* PyP3Sprite_AddMulVector (P3_sprite* a, PyObject* args) {
  P3_vector* v = (P3_vector*) PySequence_Fast_GET_ITEM (args, 1);
  GLfloat k = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0));
  if (v->parent == NULL || a->parent == NULL || a->parent == v->parent) {
    a->position[0] += k * v->coord[0];
    a->position[1] += k * v->coord[1];
    a->position[2] += k * v->coord[2];
  } else {
    GLfloat tmp[3];
    P3_vector_by_matrix_copy (tmp, v->coord, P3_coordsys_get_root_matrix (v->parent));
    P3_vector_by_matrix (tmp, P3_coordsys_get_inverted_root_matrix (a->parent));
    a->position[0] += k * tmp[0];
    a->position[1] += k * tmp[1];
    a->position[2] += k * tmp[2];
  }
  P3_object_invalid ((P3_any_object*) a);
  Py_INCREF ((PyObject*) a);
  return (PyObject*) a;
}

static PyObject* PyP3Sprite_DistanceTo (P3_sprite* a, PyObject* arg) {
  GLfloat t[3];
  PyP3_GetPositionInto (arg, a->parent, t);
  t[0] -= a->position[0];
  t[1] -= a->position[1];
  t[2] -= a->position[2];
  return PyFloat_FromDouble (sqrt (t[0] * t[0] + t[1] * t[1] + t[2] * t[2]));
}

static PyObject* PyP3Sprite_VectorTo (P3_sprite* a, PyObject* arg) {
  P3_vector* new = (P3_vector*) PyP3Vector_Type.tp_alloc (&PyP3Vector_Type, 0);
  new->parent = a->parent;
  if (new->parent != NULL) Py_INCREF (new->parent);
  PyP3_GetPositionInto (arg, a->parent, new->coord);
  new->coord[0] -= a->position[0];
  new->coord[1] -= a->position[1];
  new->coord[2] -= a->position[2];
  return (PyObject*) new;
}

static PyMethodDef PyP3Sprite_Methods[] = {
  { "vector_to",       (PyCFunction) PyP3Sprite_VectorTo,       METH_O },
  { "distance_to",     (PyCFunction) PyP3Sprite_DistanceTo,     METH_O },
  { "add_mul_vector",  (PyCFunction) PyP3Sprite_AddMulVector,   METH_VARARGS },
  { "add_vector",      (PyCFunction) PyP3Sprite_AddVector,      METH_O },
  { "position",        (PyCFunction) PyP3Sprite_Position,       METH_NOARGS },
  { "move",            (PyCFunction) PyP3Sprite_Move,           METH_O },
  { "get_root",        (PyCFunction) PyP3Coordsys_GetRoot,      METH_NOARGS },
  { "translate",       (PyCFunction) PyP3Sprite_Translate,      METH_VARARGS },
  { "set_xyz",         (PyCFunction) PyP3Sprite_SetXyz,         METH_VARARGS },
  { "begin_round",     (PyCFunction) PyP3_EmptyFunc,            METH_VARARGS },
  { "advance_time",    (PyCFunction) PyP3_EmptyFunc,            METH_VARARGS },
  { "end_round",       (PyCFunction) PyP3_EmptyFunc,            METH_VARARGS },
  { "inside",          (PyCFunction) PyP3Coordsys_Inside,       METH_O },
  { "_getstate",       (PyCFunction) PyP3Sprite_GetState,       METH_NOARGS },
  { "_setstate",       (PyCFunction) PyP3Sprite_SetState,       METH_O },
  { NULL, NULL } /* sentinel */
};

/*---------+
 | Get Set |
 +---------*/

static PyObject* PyP3Sprite_GetLit (P3_any_object* a, void* context) {
  if (a->option & P3_SPRITE_NEVER_LIT) {
    return PyInt_FromLong (0);
  } else {
    return PyInt_FromLong (1);
  }
}

static int PyP3Sprite_SetLit (P3_any_object* a, PyObject* value, void* context) {
  if (PyObject_IsTrue (value) == 1) {
    a->option &= ~P3_SPRITE_NEVER_LIT;
  } else {
    a->option |= P3_SPRITE_NEVER_LIT; 
  }
  return 0;
}

PY_GET_SET_ON_FLOAT           (Sprite, P3_sprite*, X, position[0])
PY_GET_SET_ON_FLOAT           (Sprite, P3_sprite*, Y, position[1])
PY_GET_SET_ON_FLOAT           (Sprite, P3_sprite*, Z, position[2])
PY_GET_SET_ON_FLOAT           (Sprite, P3_sprite*, Width,  w)
PY_GET_SET_ON_FLOAT           (Sprite, P3_sprite*, Height, h)
PY_GET_SET_ON_FLOAT_ARRAY_ADD (Sprite, P3_sprite*, Color, color, 4, P3_sprite_compute_alpha (a);)
PY_GET_SET_ON_OBJECT_ADD      (Sprite, P3_sprite*, Material, material, P3_material*, P3_sprite_compute_alpha (a);)

static PyGetSetDef PyP3Sprite_GetSets[] = {
  { "visible", (getter) PyP3Object_GetVisible,  (setter) PyP3Object_SetVisible,   NULL },
  { "_parent", (getter) PyP3Child_GetParent,    (setter) PyP3Child_SetParent,     NULL },
  { "parent",  (getter) PyP3Child_GetParent,    (setter) PyP3Child_ChangeParent,  NULL },
//  PYP3_CHILD_GETSETS,
//  PYP3_VISIBLE_GETSETS,
  { "color",    (getter) PyP3Sprite_GetColor,    (setter) PyP3Sprite_SetColor,    NULL },
  { "width",    (getter) PyP3Sprite_GetWidth,    (setter) PyP3Sprite_SetWidth,    NULL },
  { "height",   (getter) PyP3Sprite_GetHeight,   (setter) PyP3Sprite_SetHeight,   NULL },
  { "x",        (getter) PyP3Sprite_GetX,        (setter) PyP3Sprite_SetX,        NULL },
  { "y",        (getter) PyP3Sprite_GetY,        (setter) PyP3Sprite_SetY,        NULL },
  { "z",        (getter) PyP3Sprite_GetZ,        (setter) PyP3Sprite_SetZ,        NULL },
  { "material", (getter) PyP3Sprite_GetMaterial, (setter) PyP3Sprite_SetMaterial, NULL },
  { "lit",      (getter) PyP3Sprite_GetLit,      (setter) PyP3Sprite_SetLit,      NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

static PyNumberMethods PyP3Sprite_AsNumber = {
  (binaryfunc) PyP3Sprite_Add, /*nb_add*/
  (binaryfunc) PyP3Sprite_Sub, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  (binaryfunc) PyP3Sprite_Mod, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  (binaryfunc) PyP3Sprite_VectorTo, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /* nb_oct */
  0, /* nb_hex */
  (binaryfunc) PyP3Sprite_AddVector, /* nb_inplace_add */
  0, /* nb_inplace_subtract */
  0, /* nb_inplace_multiply */
  0, /* nb_inplace_divide */
  0, /* nb_inplace_remainder */
  0, /* nb_inplace_power */
  0, /* nb_inplace_lshift */
  0, /* nb_inplace_rshift */
  0, /* nb_inplace_and */
  0, /* nb_inplace_xor */
  0, /* nb_inplace_or */
  0, /* nb_floor_divide */
  0, /* nb_true_divide */
  0, /* nb_inplace_floor_divide */
  0, /* nb_inplace_true_divide */
};

PyTypeObject PyP3Sprite_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Sprite",
  sizeof(P3_sprite),
  0,
  (destructor) PyP3Sprite_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  &PyP3Sprite_AsNumber,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Sprite_Traverse,/* tp_traverse */
  (inquiry) PyP3Sprite_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Sprite_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Sprite_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Sprite_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

/*==========+
 | CYLINDER |
 +==========*/

/*---------+
 | Methods |
 +---------*/

static int PyP3Cylinder_Init (P3_cylinder* a, PyObject* args, PyObject* kwds) {
  P3_cylinder_new (a);
  return 0;
}

static PyObject* PyP3Cylinder_GetState (P3_cylinder* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_cylinder_get_data (a, chunk);
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
  if (a->material == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 1, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->material);
    PyTuple_SET_ITEM (tuple, 1, (PyObject*) a->material);
  }
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Cylinder_SetState (P3_cylinder* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_cylinder_set_data (a, chunk);
  a->material = (P3_material*) PySequence_Fast_GET_ITEM (args, 1);
  if ((PyObject*) a->material == Py_None) {
    a->material = NULL;
  } else {
    Py_INCREF ((PyObject*) a->material);
  }
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3Cylinder_Shift (P3_cylinder* a, PyObject* arg) {
  GLfloat f = (GLfloat) PyFloat_AS_DOUBLE (arg);
  a->position[0] += f * a->direction[0];
  a->position[1] += f * a->direction[1];
  a->position[2] += f * a->direction[2];
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3Cylinder_RotateIncline (P3_cylinder* a, PyObject* arg) {
  P3_point_rotate_incline (a->direction, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3Cylinder_RotateVertical (P3_cylinder* a, PyObject* arg) {
  P3_point_rotate_vertical (a->direction, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3Cylinder_RotateLateral (P3_cylinder* a, PyObject* arg) {
  P3_point_rotate_lateral (a->direction, (GLfloat) P3_to_radians(PyFloat_AS_DOUBLE (arg)));
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3Cylinder_RotateAxe (P3_cylinder* a, PyObject* args) {
  P3_point_rotate_axe (a->direction, 
                       (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))),
                       (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)),
                       (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)),
                       (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3)));
  Py_INCREF (Py_None);
  return Py_None;
}

PyObject* PyP3Cylinder_Rotate (P3_cylinder* a, PyObject* args) {
  GLfloat p1[3];
  GLfloat p2[3];
  p1[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  p1[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  p1[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3));
  p2[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 4));
  p2[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 5));
  p2[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 6));
  P3_point_rotate (a->direction, 
                   (GLfloat) P3_to_radians (PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0))),
                   p1, p2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Cylinder_Methods[] = {
  { "_getstate",       (PyCFunction) PyP3Cylinder_GetState,       METH_NOARGS },
  { "_setstate",       (PyCFunction) PyP3Cylinder_SetState,       METH_O },
//  { "translate",       (PyCFunction) PyP3Sprite_Translate,        METH_VARARGS },
//  { "set_xyz",         (PyCFunction) PyP3Sprite_SetXyz,           METH_VARARGS },
  { "shift",           (PyCFunction) PyP3Cylinder_Shift,          METH_VARARGS },
  { "rotate_incline",  (PyCFunction) PyP3Cylinder_RotateIncline,  METH_O },
  { "rotate_vertical", (PyCFunction) PyP3Cylinder_RotateVertical, METH_O },
  { "rotate_lateral",  (PyCFunction) PyP3Cylinder_RotateLateral,  METH_O },
  { "rotate_axe",      (PyCFunction) PyP3Cylinder_RotateAxe,      METH_VARARGS },
  { "rotate",          (PyCFunction) PyP3Cylinder_Rotate,         METH_VARARGS },
  { NULL, NULL } /* sentinel */
};

/*---------+
 | Get Set |
 +---------*/

PY_GET_SET_ON_FLOAT_ARRAY (Cylinder, P3_cylinder*, Direction, direction, 3)

static PyGetSetDef PyP3Cylinder_GetSets[] = {
//  PYP3_CHILD_GETSETS,
//  PYP3_VISIBLE_GETSETS,
//  { "color",     (getter) PyP3Sprite_GetColor,       (setter) PyP3Sprite_SetColor,       NULL },
//  { "width",     (getter) PyP3Sprite_GetWidth,       (setter) PyP3Sprite_SetWidth,       NULL },
//  { "height",    (getter) PyP3Sprite_GetHeight,      (setter) PyP3Sprite_SetHeight,      NULL },
//  { "x",         (getter) PyP3Sprite_GetX,           (setter) PyP3Sprite_SetX,           NULL },
//  { "y",         (getter) PyP3Sprite_GetY,           (setter) PyP3Sprite_SetY,           NULL },
//  { "z",         (getter) PyP3Sprite_GetZ,           (setter) PyP3Sprite_SetZ,           NULL },
//  { "material",  (getter) PyP3Sprite_GetMaterial,    (setter) PyP3Sprite_SetMaterial,    NULL },
//  { "lit",      (getter) PyP3Sprite_GetLit,      (setter) PyP3Sprite_SetLit,      NULL },
  { "direction", (getter) PyP3Cylinder_GetDirection, (setter) PyP3Cylinder_SetDirection, NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Cylinder_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Cylinder",
  sizeof(P3_cylinder),
  0,
  (destructor) PyP3Sprite_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Sprite_Traverse,/* tp_traverse */
  (inquiry) PyP3Sprite_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Cylinder_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Cylinder_GetSets,/* tp_getset */
  &PyP3Sprite_Type,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Cylinder_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

/*=======+
 | BONUS |
 +=======*/

/*---------+
 | Methods |
 +---------*/

static int PyP3Bonus_Init (P3_bonus* a, PyObject* args, PyObject* kwds) {
  P3_bonus_new (a);
  return 0;
}

static void PyP3Bonus_Dealloc (P3_bonus* a) {
  PyObject_GC_UnTrack ((PyObject*) a);
  Py_XDECREF (a->material);
  Py_XDECREF (a->halo);
  a->ob_type->tp_free ((PyObject*) a); 
}

static int PyP3Bonus_Traverse (P3_bonus* a, visitproc visit, void* arg) {
  int err;
  if (a->material != NULL) {
    err = visit ((PyObject*) a->material, arg);
    if (err) { return err; }
  }
  if (a->halo != NULL) {
    err = visit ((PyObject*) a->halo, arg);
    if (err) { return err; }
  }
  return 0;
}

static int PyP3Bonus_Clear (P3_bonus* a) {
  Py_XDECREF (a->material);
  a->material = NULL;
  Py_XDECREF (a->halo);
  a->halo = NULL;
  return 0;
}

static PyObject* PyP3Bonus_GetState (P3_bonus* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_bonus_get_data (a, chunk);
  tuple = PyTuple_New (3);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
  if (a->material == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 1, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->material);
    PyTuple_SET_ITEM (tuple, 1, (PyObject*) a->material);
  }
  if (a->halo == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 2, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->halo);
    PyTuple_SET_ITEM (tuple, 2, (PyObject*) a->halo);
  }
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Bonus_SetState (P3_bonus* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_bonus_set_data (a, chunk);
  a->material = (P3_material*) PySequence_Fast_GET_ITEM (args, 1);
  if ((PyObject*) a->material == Py_None) {
    a->material = NULL;
  } else {
    Py_INCREF ((PyObject*) a->material);
  }
  a->halo = (P3_material*) PySequence_Fast_GET_ITEM (args, 2);
  if ((PyObject*) a->halo == Py_None) {
    a->halo = NULL;
  } else {
    Py_INCREF ((PyObject*) a->halo);
  }
  a->angle = 0.0;
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Bonus_Methods[] = {
  { "_getstate", (PyCFunction) PyP3Bonus_GetState, METH_NOARGS },
  { "_setstate", (PyCFunction) PyP3Bonus_SetState, METH_O },
  { NULL, NULL } /* sentinel */
};

/*---------+
 | Get Set |
 +---------*/

PY_GET_SET_ON_OBJECT      (Bonus, P3_bonus*, Material, material, P3_material*)
PY_GET_SET_ON_OBJECT      (Bonus, P3_bonus*, Halo, halo, P3_material*)
PY_GET_SET_ON_FLOAT_ARRAY (Bonus, P3_bonus*, Color, color, 4)
//PY_GET_SET_ON_OPTION      (Bonus, P3_bonus*, NeverLit, P3_R_NEVER_LIT)

static PyGetSetDef PyP3Bonus_GetSets[] = {
  PYP3_CHILD_GETSETS,
//  { "never_lit", (getter) PyP3Bonus_GetNeverLit, (setter) PyP3Bonus_SetNeverLit, NULL },
  { "color", (getter) PyP3Bonus_GetColor, (setter) PyP3Bonus_SetColor, NULL },
  { "material", (getter) PyP3Bonus_GetMaterial, (setter) PyP3Bonus_SetMaterial, NULL },
  { "halo", (getter) PyP3Bonus_GetHalo, (setter) PyP3Bonus_SetHalo, NULL },
  { "lit",      (getter) PyP3Sprite_GetLit,      (setter) PyP3Sprite_SetLit,      NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Bonus_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Bonus",
  sizeof(P3_bonus),
  0,
  (destructor) PyP3Bonus_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Bonus_Traverse,/* tp_traverse */
  (inquiry) PyP3Bonus_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Bonus_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Bonus_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Bonus_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

