/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/

/*=============*
 * RASTER FONT *
 *=============*/

/*---------+
 | Methods |
 +---------*/

static void PyP3FontRaster_Dealloc (P3_font_raster* f) {
  if (engine_option & P3_GL_INITED && glIsList (f->call_list) == GL_TRUE) { glDeleteLists (f->call_list, f->nb_chars); }
  free (f->chars);
  f->ob_type->tp_free ((PyObject*) f);
}

static int PyP3FontRaster_Init (P3_font_raster* self, PyObject* args, PyObject* kwds) {
  if (PySequence_Size (args) == 5) {
    P3_font_raster_from_freetype (self, PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)), 
                                  PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)), PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                                  PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 3)), PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 4)));
  } else {
    P3_font_raster_from_image (self, 
                               (P3_image*) PySequence_Fast_GET_ITEM (args, 0),
                               (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                               (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                               (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 3)));
  }
  return 0;
}

static PyObject* PyP3FontRaster_Print2D (P3_font_raster* f, PyObject* args) {
  int rw; int rh;
  PyObject* tuple;
  P3_font_raster_print_2i (f, 
                           PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                           (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                           (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                           &rw, &rh);
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong ((long) rw));
  PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong ((long) rh));
  return tuple;
}

static PyObject* PyP3FontRaster_PrintArea2D (P3_font_raster* f, PyObject* args) {
  return PyInt_FromLong ((long) P3_font_raster_print_area (f, 
                                                           PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                                                           (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                                                           (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                                                           (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 3)),
                                                           (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 4)),
                                                           (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 5))));
}

static PyObject* PyP3FontRaster_Print3D (P3_font_raster* f, PyObject* args) {
  P3_font_raster_print_3f (f, 
                           PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                           (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)),
                           (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)),
                           (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3FontRaster_Save (P3_font_raster* f, PyObject* arg) {
  P3_font_raster_save (f, PyString_AS_STRING (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3FontRaster_Methods[] = {
  { "draw_area", (PyCFunction) PyP3FontRaster_PrintArea2D, METH_VARARGS },
  { "draw_2D",   (PyCFunction) PyP3FontRaster_Print2D,     METH_VARARGS },
  { "draw_3D",   (PyCFunction) PyP3FontRaster_Print3D,     METH_VARARGS },
  { "save",      (PyCFunction) PyP3FontRaster_Save,        METH_O },
  { NULL, NULL }
};

/*---------+
 | Get Set |
 +---------*/

static PyObject* PyP3FontRaster_GetCharHeight (P3_font_raster* a, void* context) {
  return PyInt_FromLong((long) a->height);
}

static PyGetSetDef PyP3FontRaster_GetSets[] = {
  { "height", (getter) PyP3FontRaster_GetCharHeight, (setter) 0, NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3FontRaster_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya.FontRaster",
  sizeof(P3_font_raster),
  0,
  (destructor) PyP3FontRaster_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) 0,/* tp_traverse */
  (inquiry) 0,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3FontRaster_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3FontRaster_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3FontRaster_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_FREE,/* tp_free */
};


/*==============*
 * TEXTURE FONT *
 *==============*/

/*---------+
 | Methods |
 +---------*/

static void PyP3FontTexture_Dealloc (P3_font_texture* f) {
  P3_font_texture_dealloc (f);
  f->ob_type->tp_free ((PyObject*) f);
}

static int PyP3FontTexture_Init (P3_font_texture* self, PyObject* args, PyObject* kwds) {
  GLubyte color_limit[4];
  PyObject* o;
  int i;
  if (PySequence_Size (args) == 5) {
    P3_font_texture_from_freetype (self, PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)), 
                                   PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)), PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                                   PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 3)), PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 4)));
  } else {
    o = PySequence_Fast_GET_ITEM (args, 2);
    for (i = 0; i < PySequence_Size (o); i++) {
      color_limit[i] = (GLubyte) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (o, i));
    }
    P3_font_texture_from_image (self, 
                                (P3_image*) PySequence_Fast_GET_ITEM (args, 0),
                                (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                                color_limit);
  }
  return 0;
}

static PyObject* PyP3FontTexture_GetPrintSize (P3_font_texture* f, PyObject* args) {
  int w; int h;
  PyObject* tuple;
  char* s = PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0));
  if (PySequence_Size (args) == 1) {
    P3_font_texture_get_size (f, s, -1, &w, &h, NULL);
    tuple = PyTuple_New (2);
    PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong ((long) w));
    PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong ((long) h));
  } else {
    char* txt;
    txt = (char*) malloc ((strlen (s) + 1) * sizeof (char));
    txt = P3_font_texture_get_size (f, s, (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)), &w, &h, txt);
    tuple = PyTuple_New (3);
    PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong ((long) w));
    PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong ((long) h));
    PyTuple_SET_ITEM (tuple, 2, PyString_FromString (txt));
    free (txt);
  }
  return tuple;
}

static PyObject* PyP3FontTexture_Print2D (P3_font_texture* f, PyObject* args) {
  PyObject* tuple;
  PyObject* o;
  int rh; int rw;
  int i;
  i = PySequence_Size (args);
  if (i == 3) {
    P3_font_texture_print_2i (f, 
                              PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                              (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                              (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                              &rw, &rh);
  } else if (i == 4) {
    o = PySequence_Fast_GET_ITEM (args, 3);
    P3_font_texture_print_2i_s (f, 
                                PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                                (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                                (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                                (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0)),
                                (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1)),
                                &rw, &rh);
  } else if (i == 5) {
    GLfloat color1[4];
    GLfloat color2[4];
    PY_TUPLE_FLOAT_TO_ARRAY_4 (color1, PySequence_Fast_GET_ITEM (args, 3));
    PY_TUPLE_FLOAT_TO_ARRAY_4 (color2, PySequence_Fast_GET_ITEM (args, 4));
    P3_font_texture_print_2i_c (f, 
                                PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                                (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                                (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                                color1, color2, &rw, &rh);
  } else if (i == 6) {
    GLfloat color1[4];
    GLfloat color2[4];
    PY_TUPLE_FLOAT_TO_ARRAY_4 (color1, PySequence_Fast_GET_ITEM (args, 4));
    PY_TUPLE_FLOAT_TO_ARRAY_4 (color2, PySequence_Fast_GET_ITEM (args, 5));
    o = PySequence_Fast_GET_ITEM (args, 3);
    P3_font_texture_print_2i_sc (f, 
                                 PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                                 (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                                 (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                                 (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 0)),
                                 (float) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (o, 1)),
                                 color1, color2, &rw, &rh);
  }
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyInt_FromLong ((long) rw));
  PyTuple_SET_ITEM (tuple, 1, PyInt_FromLong ((long) rh));
  return tuple;
}

static PyObject* PyP3FontTexture_PrintArea2D (P3_font_texture* f, PyObject* args) {
  return PyInt_FromLong ((long) P3_font_texture_print_area (f, 
                                                            PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                                                            (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1)),
                                                            (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 2)),
                                                            (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 3)),
                                                            (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 4)),
                                                            (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 5))));
}

static PyObject* PyP3FontTexture_Print3D (P3_font_texture* f, PyObject* args) {
/*
  P3_font_texture_print_3f (f, 
                            PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0)),
                            (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)),
                            (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)),
                            (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3)));
*/
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3FontTexture_Save (P3_font_texture* f, PyObject* arg) {
  P3_font_texture_save (f, PyString_AS_STRING (arg));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3FontTexture_SetPosition (P3_font_texture* f, PyObject* args) {
  static GLfloat matrix[16] = { 1.0, 0.0, 0.0, 0.0, 
                                0.0, 1.0, 0.0, 0.0, 
                                0.0, 0.0, 1.0, 0.0, 
                                0.0, 0.0, 0.0, 1.0 };
  if (args == NULL || args == Py_None || PySequence_Size (args) == 0) {
    glLoadIdentity ();
  } else {
    matrix[12] = (GLfloat) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 0));
    matrix[13] = (GLfloat) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1));
    glLoadMatrixf (matrix);
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3FontTexture_Methods[] = {
  { "draw_area",      (PyCFunction) PyP3FontTexture_PrintArea2D,  METH_VARARGS },
  { "draw_2D",        (PyCFunction) PyP3FontTexture_Print2D,      METH_VARARGS },
  { "draw_3D",        (PyCFunction) PyP3FontTexture_Print3D,      METH_VARARGS },
  { "set_position",   (PyCFunction) PyP3FontTexture_SetPosition,  METH_VARARGS },
  { "get_print_size", (PyCFunction) PyP3FontTexture_GetPrintSize, METH_VARARGS },
  { "save",           (PyCFunction) PyP3FontTexture_Save,         METH_O },
  { NULL, NULL }
};

/*---------+
 | Get Set |
 +---------*/

static PyObject* PyP3FontTexture_GetCharHeight (P3_font_texture* a, void* context) {
  return PyInt_FromLong((long) a->char_height);
}

static PyGetSetDef PyP3FontTexture_GetSets[] = {
  { "height", (getter) PyP3FontTexture_GetCharHeight, (setter) 0, NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3FontTexture_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya.FontTexture",
  sizeof(P3_font_texture),
  0,
  (destructor) PyP3FontTexture_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) 0,/* tp_traverse */
  (inquiry) 0,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3FontTexture_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3FontTexture_GetSets,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3FontTexture_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_FREE,/* tp_free */
};

static PyObject* PyP3_LoadFont (PyObject* module, PyObject* arg) {
  PyObject* f;
  FILE* file;
  char* filename;
  int i;
  filename = PyString_AS_STRING (arg);
  file = fopen (filename, "rb");
  if (file == NULL) { 
    P3_error ("can't open file %s", filename); 
    Py_INCREF (Py_None);
    return Py_None;
  }
  fread (&i, 1, sizeof (int), file);
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
  SDL_Swap32 (i);
#endif
  if (i == P3_FONT_RASTER) {
    f = PyP3FontRaster_Type.tp_alloc (&PyP3FontRaster_Type, 0);
    P3_font_raster_load ((P3_font_raster*) f, file);
  } else if (i == P3_FONT_TEXTURE) {
    f = PyP3FontTexture_Type.tp_alloc (&PyP3FontTexture_Type, 0);
    P3_font_texture_load ((P3_font_texture*) f, file);
  } else {
    P3_error ("unknown font type (%i)", i); 
    Py_INCREF (Py_None);
    return Py_None;
  }
  return f;
}
