# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import pickle, os, os.path, math
import py2play.level as level
import py2play.idler as idler
import soya, soya.soya3d as soya3d, soya.widget as widget, soya.game.camera as game_camera
from soya.math3d import Point, Vector


class Idler(soya3d.World, idler.Idler):
  def __init__(self, camera = None):
    soya3d.World.__init__(self)
    idler.Idler .__init__(self)
    
    self.camera = camera or game_camera.TravelingCamera(self)
    soya.set_root_widget(widget.Group())
    soya.root_widget.add(self.camera)
    
  def begin_round(self):
    # In THIS order !!! Say to Py2Play the round begin before doing anything !
    idler.Idler.begin_round(self)

    # The camera must be played AFTER the character, for a better visual effect (ie to avoid the character to move after the camera has been moved)
    for child in self.children:
      if hasattr(child, "begin_round") and (not child is self.camera):
        child.begin_round()
      
    #self.camera.begin_round()
    
    soya.root_widget.begin_round()
    
  def end_round(self):
    # In THIS order !!! Really ends the round before saying to Py2Play it is ended !
    # The camera must be played AFTER the character, for a better visual effect (ie to avoid the character to move after the camera has been moved)
    for child in self.children:
      if hasattr(child, "end_round") and (not child is self.camera): child.end_round()
      
    #self.camera.end_round()
    
    soya.root_widget.end_round()
    
    idler.Idler .end_round(self)
    
  def advance_time(self, proportion = 1.0):
    soya.advance_time(proportion)
    for child in self.children:
      if hasattr(child, "advance_time") and (not child is self.camera):
        child.advance_time(proportion)
    soya.root_widget.advance_time(proportion)
    
  def render(self):
    soya.render()
    
  def show_fps(self):
    soya.root_widget.add(FPSLabel())
    
  
class Level(level.Level, soya3d.World):
  def __init__(self, parent = None):
    level.Level .__init__(self, "")
    soya3d.World.__init__(self, parent)

  def remove_character(self, character):
    level.Level.remove_character(self, character)
    self.remove(character)
    
  def set_active(self, active):
    level.Level.set_active(self, active)
    
    if self.active: idler.IDLER.append(self)
    else:           idler.IDLER.remove(self)


import _soya

class FPSLabel(widget.Widget):
  def resize(self, parent_left, parent_top, parent_width, parent_height):
    self.x = parent_left + parent_width  - 155
    self.y = parent_top  + parent_height - 37
    
  def render(self):
    _soya.glColor4f(1.0, 1.0, 1.0, 1.0)
    widget.default_font.draw_area("%.1f FPS" % idler.IDLER.fps, self.x, self.y, 150, 30, 1)
    #widget.default_font.draw_area("%.1f FPS" % idler.IDLER.fps, _soya.get_screen_width() - 150, _soya.get_screen_height() - 30, 150, 30, 1)


