#! /usr/bin/env python

# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY -- jiba@tuxfamily
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os.path, sys, glob, distutils.core, distutils.sysconfig
from distutils.core import setup, Extension

HERE = os.path.dirname(sys.argv[0])

from config import *

LIBS   = ["m", "GL", "SDL", "png", "freetype", "cal3d", "stdc++"]
DEFINE = [
  ("COMPILE_FOR_PYTHON", None),
  ("USE_SDL", None),
  ("SAFE_MODE", None),
  ("HAVE_LIBPNG", None),
  ("HAVE_FREETYPE2", None),
  ("HAVE_CAL3D", None),
  ]
INCDIR = [
  "/usr/include",
  "/usr/local/include",
  "/usr/X11R6/lib",
  "/usr/include/freetype2",
  "/usr/local/include/freetype2",
  "/usr/include/cal3d",
  "/usr/local/include/cal3d",
  "/sw/include", # For Mac OS X
  ]
LIBDIR = [
  "/usr/lib",
  "/usr/local/lib",
  "/usr/X11R6/lib",
  "/sw/lib/", # For Mac OS X
  ]

if OPENGL_INCDIR: INCDIR.append(OPENGL_INCDIR)
if OPENGL_LIBDIR: LIBDIR.append(OPENGL_LIBDIR)
if SDL_INCDIR:    INCDIR.append(SDL_INCDIR)
if SDL_LIBDIR:    LIBDIR.append(SDL_LIBDIR)

if HAVE_LIBPNG == 1:
  LIBS.append(LIBPNG_LIB)
  DEFINE.append(('HAVE_LIBPNG', None))
  if LIBPNG_INCDIR: INCDIR.append(LIBPNG_INCDIR)
  if LIBPNG_LIBDIR: LIBDIR.append(LIBPNG_LIBDIR)
if HAVE_FREETYPE2 == 1:
  LIBS.append(FREETYPE2_LIB)
  DEFINE.append(('HAVE_FREETYPE2', None))
  if FREETYPE2_INCDIR: INCDIR.append(FREETYPE2_INCDIR)
  if FREETYPE2_LIBDIR: LIBDIR.append(FREETYPE2_LIBDIR)
if HAVE_CAL3D == 1:
  LIBS.append(CAL3D_LIB)
  DEFINE.append(('HAVE_CAL3D', None))
  if CAL3D_INCDIR: INCDIR.append(CAL3D_INCDIR)
  if CAL3D_LIBDIR: LIBDIR.append(CAL3D_LIBDIR)


def c_src():
  return glob.glob(os.path.join("c_src", "*.c"))


# Put the data along with the lib
install_dir = distutils.sysconfig.get_python_lib()

distutils.core.setup(
  name         = "Soya",
  version      = "0.6.1",
  license      = "GPL",
  description  = "A practical high-level object-oriented 3D engine for Python.",
  long_description  = """A practical high-level object-oriented 3D engine for Python.
Soya is designed with game in mind. It includes heightmaps, particles systems, animation support,...""",
  keywords     = "3D engine openGL python",
  author       = "Jiba (LAMY Jean-Baptiste), Blam (LAMY Bertrand)",
  author_email = "jiba@tuxfamily.org",
  url          = "http://oomadness.tuxfamily.org/en/soya",
  home_page    = "http://oomadness.tuxfamily.org/en/soya",
  classifiers  = [
  "Topic :: Multimedia :: Graphics :: 3D Rendering",
  "Topic :: Software Development :: Libraries :: Python Modules",
  "Programming Language :: Python",
  "Intended Audience :: Developers",
  "Development Status :: 5 - Production/Stable",
  "License :: OSI Approved :: GNU General Public License (GPL)",
  ],

  scripts      = ["soya_editor"],
  package_dir  = {"soya" : ""},
  packages     = ["soya", "soya.editor", "soya.game"],

  data_files   = [(os.path.join(install_dir, "soya", "data"),
                   [os.path.join("data", file) for file in os.listdir("data") if file != "CVS"]
                   )],
  
  ext_modules = [Extension("_soya",
                               ["./c_src/atmosphere.c",
                                "./c_src/material.c",
                                "./c_src/mesh_render.c",
                                "./c_src/mesh_tree.c",
                                "./c_src/mesh_raypick.c",
                                "./c_src/mesh_build.c",
                                "./c_src/mesh_fileio.c",
                                "./c_src/mesh_lod.c",
                                "./c_src/mesh_fx.c",
#                                "./c_src/xmesh_shadow.c",
                                "./c_src/mesh.c",
                                "./c_src/shadow.c",
                                "./c_src/fx.c",
                                "./c_src/anim.c",
                                "./c_src/cal3d4p3.c",
#                                "./c_src/cmesh.c",
                                "./c_src/camera.c",
                                "./c_src/coordsys.c",
                                "./c_src/engine.c",
                                "./c_src/frustum.c",
                                "./c_src/gladd.c",
                                "./c_src/image.c",
                                "./c_src/volume.c",
                                "./c_src/light.c",
                                "./c_src/math3d.c",
                                "./c_src/renderer.c",
                                "./c_src/util.c",
                                "./c_src/world.c",
                                "./c_src/portal.c",
                                "./c_src/text.c",
                                "./c_src/dimension.c",
                                "./c_src/sprite.c",
                                "./c_src/morph.c",
                                "./c_src/morph_build.c",
                                "./c_src/raypick.c",
                                "./c_src/land.c",
                                "./c_src/watercube.c",
                                "./c_src/python/p3_python.c"],
                               INCDIR,
                               DEFINE,
                               None,
                               LIBDIR,
                               LIBS,
                               )
                     ]
  )

