# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 002: Modeling : a moving pyramid

# This lesson is similar to the lesson 001, but it displays a pyramid instead of
# a cube. As there is no Soya primitive to draw a pyramid, we'll draw it by
# hand, with the functions and classes provided by the soya.model module.
# The pyramid is made of a quad base and 4 triangles.

# Import some Soya module.

import soya, soya.soya3d as soya3d, soya.model as model

# Initializes Soya (and creates the 3D window).

soya.init()

# Creates the scene.

scene = soya3d.World()

# Creates the World that will contain the whole pyramid. As previously stated, the
# pyramid is composed of 5 faces; this world is used to group those 5 faces
# (exactly like a Frame can be used in Tkinter to group different widgets).
# The pyramid's parent is the scene.

pyramid = soya3d.World(scene)

# Creates a material for the pyramid.

material = model.Material()

# Creates the first face, the quad base of the pyramid.
# The first argument of the Face constructor is the parent World (the pyramid),
# the second is the list of vertices and the third is the material.
# The number of vertices determines the Face's nature:
#  - 1: a point
#  - 2: a line
#  - 3: a triangle
#  - 4: a quad
#  - +: a polygon

# By default, the face is only visible from one side; which of the two sides
# depends on the order of the vertices. You can make the two sides visible
# with "face.double_sided = 1".

# The vertices is a list of Vertex object. The first argument of the constructor
# is (again) the parent, and the three following one are the x, y and z
# coordinates.
# 
# As 3D object, Point, Vector or Vertex have a parent too, though they are not
# considered as "children". The parent is used for automatic coordinates
# conversion, which will be detailed in a later lesson. Here, the coordinates
# are defined in the pyramid coordinate system.
# 
# The order of the vertices in the list determines which side of the face is
# visible (for triangles, quads and polygons); you can get both side visible
# by setting the "double_sided" attribute to true.

model.Face(pyramid, [model.Vertex(pyramid,  0.5, -0.5,  0.5),
                     model.Vertex(pyramid, -0.5, -0.5,  0.5),
                     model.Vertex(pyramid, -0.5, -0.5, -0.5),
                     model.Vertex(pyramid,  0.5, -0.5, -0.5),
                     ], material)

# Similarly, creates the 4 triangles.

model.Face(pyramid, [model.Vertex(pyramid, -0.5, -0.5,  0.5),
                     model.Vertex(pyramid,  0.5, -0.5,  0.5),
                     model.Vertex(pyramid,  0.0,  0.5,  0.0),
                     ], material)

model.Face(pyramid, [model.Vertex(pyramid,  0.5, -0.5, -0.5),
                     model.Vertex(pyramid, -0.5, -0.5, -0.5),
                     model.Vertex(pyramid,  0.0,  0.5,  0.0),
                     ], material)

model.Face(pyramid, [model.Vertex(pyramid,  0.5, -0.5,  0.5),
                     model.Vertex(pyramid,  0.5, -0.5, -0.5),
                     model.Vertex(pyramid,  0.0,  0.5,  0.0),
                     ], material)

model.Face(pyramid, [model.Vertex(pyramid, -0.5, -0.5, -0.5),
                     model.Vertex(pyramid, -0.5, -0.5,  0.5),
                     model.Vertex(pyramid,  0.0,  0.5,  0.0),
                     ], material)

# Creates and moves the light (see lesson 001).

light = soya3d.Light(scene)
light.set_xyz(1.0, 0.7, 1.0)

# Creates and moves the camera (see lesson 001).

camera = soya3d.Camera(scene)
camera.z = 2.0
soya.set_root_widget(camera)


def advance_time(proportion):
  pyramid.rotate_lateral(proportion * 10.0)
  pyramid.rotate_incline(proportion *  5.0)
  
pyramid.advance_time = advance_time


import time

while 1:
  soya.render()
  
  scene.begin_round()
  scene.advance_time()
  
  time.sleep(0.1)
