# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 010: File management : loading Shapes

# In this lesson, we'll load Shapes.

# Worlds are automatically converted to Shapes when required (this is similar to
# the compilation of .py file into .pyc or .pyo).

# The shape directory can be seen as a cache directory with optimized version of
# Worlds.


import soya, soya.soya3d as soya3d, soya.model as model, soya.sphere as sphere
import os, os.path, sys

soya.init()

scene = soya3d.World()


# Defines the texture, material, shape and world directories. We use the directory
# "./data" in the tutorial directory.
# For Shapes, we cannot use the same directory, since the Shape's filenames are the
# same than World's one, so we use "./data/shapes"

data_dir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")

model.Image   .PATH = os.path.join(data_dir, "images")
model.Material.PATH = os.path.join(data_dir, "materials")
soya3d.World  .PATH = os.path.join(data_dir, "worlds")
model.Shape   .PATH = os.path.join(data_dir, "shapes")


# Loads the cube saved in lesson 8, but as a shape !
# If the Shape file does not exist, or if it is older than the corresponding
# World file, a new shape is created (by calling world.shapify()) and saved/cached
# in the shape PATH.

cube_shape = model.Shape.get("textured_cube")

cube = soya3d.Volume(scene, cube_shape)
cube.x = 0.0

# Creates a light and a camera

light = soya3d.Light(scene)
light.set_xyz(0.0, 0.2, 1.0)

camera = soya3d.Camera(scene)
camera.z = 2.0
soya.set_root_widget(camera)


# Renders and waits

soya.render()

import time
while 1: time.sleep(0.1)
