# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 103: Particle system : firework !

# This lesson shows how to use do a firework !

import sys
import soya, soya.soya3d as soya3d, soya.model as model, soya.particle as particle, soya.idler as idler, soya.widget as widget

soya.init()

scene = soya3d.World()

camera = soya3d.Camera(scene)
camera.z = 5.0

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

material = particle._default()

class Generator(particle.FireworkGenerator):
  def __init__(self, colors = ((0.9, 0.7, 0.0, 0.4), (1.0, 1.0, 0.0, 1.0), (1.0, 1.0, 1.0, 1.0)), acceleration = None, initial_speed = 0.08, subgenerator = None):
    particle.FireworkGenerator.__init__(self, colors, acceleration, initial_speed, subgenerator = self)
    self.other_generator = particle.FountainGenerator()
    
  def set_system(self, system):
    particle.FireworkGenerator.set_system(self, system)
    self.other_generator.set_system(system)
    
  def __call__(self):
    #if len(self.system.particles) <= 1:
    if (len(self.system.particles) == 0) or (len(self.system.particles) == 38) or (len(self.system.particles) == 15):
      return particle.FireworkGenerator.__call__(self)
    else:
      return self.other_generator()
    

firework = particle.MultiSpriteSystem(scene, Generator(), material, nb_particles = 1, particle_width = 0.2, particle_height = 0.2)
firework.y = -2.0


idler.Idler(scene).idle()
