# Soya 3D tutorial
# Copyright (C) 2001-2002 Bertrand 'blam!' LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# -----------------------------------------
# Lesson 109: Soya3D splash screen (Widget)
# -----------------------------------------
# This lesson shows how to use some basic Widget: Label, Image and Group

import sys, os, os.path

import soya
import soya.widget
import soya.model

import soya.idler as idler


soya.init()


# Create a new Group: this Widget is a container for other Widgets and
# is the root one that is rendered on each frame
# By default a Group is resized to fill all the space given by its Master
# (the master of the root widget is the window itself)
# Notice that the parent of a Widget is called its Master and not its
# Parent to avoid confusion with the 3D objects hierarcgy (and also
# because Camera is a 3D object and a Widget so it has a different Parent
# and Master)
group = soya.widget.Group()

# Create a Widget to clear the screen
soya.widget.Clearer(group)

# Create a Material for Soya3D logo
material_logo = soya.model.Material()
material_logo.tex_filename = os.path.join(soya.DATADIR, "soya3d_logo.tga")
color = [0.0, 0.0, 0.0, 1.0]

# Create an Image Widget to display the logo
logo = soya.widget.Image(group, material_logo, color)
# As for 3D objects creation, the first argument given to call the
# constructor is the Master

# Rewrite the resize function
def create_logo_resize(logo):
  def logo_resize(parent_left, parent_top, parent_width, parent_height):
    if (parent_width < 512):
      logo.width  = parent_width
      logo.height = int(parent_width * 0.25)
    else:
      logo.width  = 512
      logo.height = 128
    logo.left = int((parent_width - logo.width) * 0.5)
    logo.top  = int(parent_height * 0.25 - logo.height * 0.5)
  return logo_resize

logo.resize = create_logo_resize(logo)


# Create a Label
text = soya.widget.Label(group, "Soya3D is a high level 3D engine written in C and Python by Jiba & Blam\n\nSoya3D is released under the GNU General Public License\n\nFor more information, please visit our website at http://oomadness.tuxfamily.org", 1, color)

def create_text_resize(text):
  def text_resize(parent_left, parent_top, parent_width, parent_height):
    text.width  = parent_width
    text.height = int(parent_height * 0.5)
    text.left   = 0
    text.top    = text.height
  return text_resize

text.resize = create_text_resize(text)


# This is set at the end, when all Widgets are added into group cause
# setting the Root Widget will launch a resize event
soya.set_root_widget(group)


ltime = 0

class Idler(idler.Idler):
  def begin_round(self):
    idler.Idler.begin_round(self)
    for event in soya.process_event():
      if (event[0] == soya.KEYDOWN or event[0] == soya.MOUSEBUTTONDOWN):
        self.stop()
  def advance_time(self, proportion):
    global ltime
    color[0] = color[0] + 0.008 * proportion
    if (color[0] > 1.0):
      color[0] = 1.0
      ltime = ltime + proportion
      if (ltime >= 20): self.stop()
    color[1] = color[0]
    color[2] = color[0]
  def render(self):
    soya.render()
    

my_idler = Idler()
my_idler.idle()
