# Soya 3D tutorial
# Copyright (C) 2001-2002 Bertrand 'blam!' LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# ---------------------------------------------------
# Lesson 110: Shape and visibility computation (Tree)
# ---------------------------------------------------

# We will see in this tutorial some technics to speed up rendering
# of big Shapes (like the Shape of a level)

import random, time

import soya
import soya.model
import soya.soya3d


soya.init()


# Create a world
scene = soya.soya3d.World()

# Add a light
light = soya.soya3d.Light(scene)
light.set_xyz(0.0, 10.0, 0.0)

# Create a world and add some randomized triangles
world = soya.soya3d.World()
i = 0
while (i < 100):
  x = random.random() * 10.0
  y = 0.0
  z = random.random() * 10.0
  v1 = soya.model.Vertex (world, x + random.random() * 2.0, y + random.random() * 2.0, z + random.random() * 2.0)
  v2 = soya.model.Vertex (world, x + random.random() * 2.0, y + random.random() * 2.0, z + random.random() * 2.0)
  v3 = soya.model.Vertex (world, x + random.random() * 2.0, y + random.random() * 2.0, z + random.random() * 2.0)
  f = soya.model.Face (world, [v1, v2, v3])
  f.double_sided = 1
  i = i + 1

# Create the Shape from the world
shape = world.shapify()


# Tree construction
# -----------------
#   Construct a sphere tree with all the faces of the shape.

shape._build_tree()


# Tree optimization
# -----------------
#   Optimize the tree (try to have a more balanced tree).
#   For now there are 2 modes of optimization.

collapse = 0.9
#   This value is used by all the mode of optimization. It means that the
#   children sphere must have a radius inferior than the parent radius multiplied
#   by collapse else the child and parent are gathered.

# Mode 0: fast. Take 1 parameter: the maximum children radius expressed in percentage
#   of the parent radius.
max_children_radius_percent = 0.5
shape._optimize_tree(collapse, 0, max_children_radius_percent)

# Mode 0: slow but compute the best possible tree. Take no parameter.
shape._optimize_tree(collapse, 1)


scene.set_shape(shape)


# If you always want to build a tree when your World is turned to Shape, you can
# use the shapify_args:
world.shapify_args=('tree', { "collapse":0.9, "mode":0, "params":[0.5] })
shape = world.shapify()
# This shape will have a Tree
scene.set_shape(shape)


# Add a camera and a loop to render
camera = soya.soya3d.Camera(scene)
camera.set_xyz(10.0, 2.0, 10.0)
camera.look_at(soya.soya3d.Point(scene, 0.0, 0.0, 0.0))
soya.set_root_widget(camera)

while(1):
  soya.render()
  time.sleep(0.1)

