# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY -- jiba@tuxfamily.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import soya, soya.soya3d
import _soya

class Land(soya._CObj, _soya._Land):
  """Land

A landscape with level of details (LOD).
"""

  filename = ""
  def __init__(self, size = 0, name = ""):
    """Land(size = 0, name = "") -> Land

Creates a new Land of size SIZE, named NAME. SIZE must be like this: (2^n)+1
(or can be 0)."""
    _soya._Land.__init__(self, size)
    self.name = name

  def fade_borders(self, color = (0.0, 0.0, 0.0, 0.0)):
    x = 0
    while (x < self.width):
      self.set_vertex_color(x, 0, color)
      x += 1
    z = 0
    while (z < self.depth):
      self.set_vertex_color(0, z, color)
      z += 1
    x = 0
    z = self.depth - 1
    while (x < self.width):
      self.set_vertex_color(x, z, color)
      x += 1
    x = self.width - 1
    z = 0
    while (z < self.depth):
      self.set_vertex_color(x, z, color)
      z += 1
    
    
  def __repr__(self):
    if self.name: return "<Land %s>" % self.name
    return "<Land>"
